package com.centit.sys.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import org.apache.struts2.ServletActionContext;
import org.springframework.util.StringUtils;

import com.centit.cas.sys.service.ICasWebClient;
import com.centit.core.action.BaseAction;
import com.centit.support.utils.DatetimeOpt;
import com.centit.sys.exception.DataSyncException;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.DataSyncManager;

/**
 * Created with IntelliJ IDEA.
 * User: sx
 * Date: 13-5-16
 * Time: 上午10:26
 * To change this template use File | Settings | File Templates.
 */

@SuppressWarnings("unchecked")
public class DataSyncAction extends BaseAction {
    private static final long serialVersionUID = -9122799732668306983L;

    private DataSyncManager dataSyncManager;

    private CodeRepositoryManager codeRepositoryManager;

    private ICasWebClient casWebClient;

    public void setCasWebClient(ICasWebClient casWebClient) {
        this.casWebClient = casWebClient;
    }

    public void setDataSyncManager(DataSyncManager dataSyncManager) {
        this.dataSyncManager = dataSyncManager;
    }

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public String list() {
        return "list";
    }




   
	public void syncAll() throws IOException {
    	PrintWriter writer = ServletActionContext.getResponse().getWriter();
    	Map<String, String> resultMap = new HashMap<String, String>();
    	resultMap.put("result", "0");
    	
        Map<Object, Object> paramMap = request.getParameterMap();
        Map<String, Object> filterMap = convertSearchColumn(paramMap);

        Date lastModDate = null;
        String date = (String) filterMap.get("lastModDate");
        if (StringUtils.hasText(date)){
            lastModDate = DatetimeOpt.convertStringToDate(date, "yyyy-MM-dd");
        }

        try {
            dataSyncManager.update(filterMap, lastModDate);

            codeRepositoryManager.refresh("usercode");
            codeRepositoryManager.refresh("unitcode");
            codeRepositoryManager.refresh("userunit");
        } catch (Exception e) {
    	    resultMap.put("result", "1");
    	    resultMap.put("msg", e.getMessage());
    	}

        
        writer.print(JSONObject.fromObject(resultMap).toString());
        
    }


    public void syncUser() throws IOException {
    	PrintWriter writer = ServletActionContext.getResponse().getWriter();
    	Map<String, String> resultMap = new HashMap<String, String>();
    	resultMap.put("result", "0");
    	
        Map<Object, Object> paramMap = request.getParameterMap();
        Map<String, Object> filterMap = convertSearchColumn(paramMap);

        try {
            dataSyncManager.updateByUsercode((String) filterMap.get("usercode"));

            codeRepositoryManager.refresh("usercode");
            codeRepositoryManager.refresh("unitcode");
            codeRepositoryManager.refresh("userunit");
        } catch (Exception e) {
            

        	resultMap.put("result", "1");
            resultMap.put("msg", e.getMessage());
        }

        writer.print(JSONObject.fromObject(resultMap).toString());
    }
}
