/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Repository(value="userRoleDao")
public class UserRoleDaoImpl
extends BaseDaoImpl<UserRole, UserRoleId>
implements UserRoleDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("roleCode", "EQUAL");
            this.filterField.put("userCode", "EQUAL");
            this.filterField.put("roleName", "LIKE");
            this.filterField.put("roleUnitCode", "ROLE_CODE in (select ro.ROLE_CODE from f_roleinfo ro where (ro.ROLE_TYPE = 'P' or (ro.ROLE_TYPE = 'D' and ro.UNIT_CODE = :roleUnitCode)))");
            this.filterField.put("unitCode", "USER_CODE in (select uu.USER_CODE from F_USERUNIT uu where uu.UNIT_CODE = :unitCode)");
            this.filterField.put("userCode_isValid", "userCode in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :userCode_isValid)");
            this.filterField.put("(like)userName", "userCode in (select us.USER_CODE from f_userinfo us where (us.USER_NAME like :userName or us.LOGIN_NAME like :userName))");
            this.filterField.put("(STARTWITH)unitPath", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_PATH like :unitPath))");
            this.filterField.put("userValid", "userCode in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :userValid)");
            this.filterField.put("roleValid", "roleCode in (select us.ROLE_CODE from f_roleinfo us where us.IS_VALID = :roleValid)");
        }
        return this.filterField;
    }

    @Transactional
    public List<UserRole> listUserRoles(String userCode) {
        return super.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}));
    }

    @Transactional
    public List<UserRole> listRoleUsers(String roleCode) {
        return super.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Transactional
    public void deleteObjectById(UserRoleId id) {
        super.deleteObjectById((Object)id);
    }

    @Transactional
    public UserRole getObjectById(UserRoleId id) {
        return (UserRole)super.getObjectById((Object)id);
    }

    @Transactional
    public void deleteByRoleId(String roid) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roid}));
    }

    @Transactional
    public void deleteByUserId(String usid) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", usid}));
    }

    @Transactional
    public List<FVUserRoles> listUserRolesByUserCode(String userCode) {
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}), FVUserRoles.class));
    }

    @Transactional
    public List<FVUserRoles> listRoleUsersByRoleCode(String roleCode) {
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}), FVUserRoles.class));
    }

    @Transactional
    public int pageCountUserRole(Map<String, Object> filterDescMap) {
        String sql = "select count(*) as cnt from F_V_USERROLES u where 1=1 [:roleCode | and u.ROLE_CODE = :roleCode] [:userCode | and u.USER_CODE = :userCode][:obtainType | and u.OBTAIN_TYPE = :obtainType] ";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterDescMap);
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams()));
    }

    @Transactional
    public List<FVUserRoles> pageQueryUserRole(Map<String, Object> pageQureyMap) {
        String querySql = "select u.USER_CODE,u.ROLE_CODE,u.ROLE_NAME,u.IS_VALID,u.ROLE_DESC, u.ROLE_TYPE,u.UNIT_CODE,u.OBTAIN_TYPE,u.INHERITED_FROM from F_V_USERROLES u where 1=1 [:roleCode | and u.ROLE_CODE = :roleCode] [:userCode | and u.USER_CODE = :userCode][:obtainType | and u.OBTAIN_TYPE = :obtainType] ";
        PageDesc pageDesc = QueryParameterPrepare.fetchPageDescParams(pageQureyMap);
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, pageQureyMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), FVUserRoles.class, (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
    }

    @Transactional
    public void deleteByRoleCodeAndUserCode(String roleCode, String userCode) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "roleCode", roleCode}));
    }

    @Transactional
    public UserRole getValidUserRole(String userCode, String rolecode) {
        String sql = "select u.USER_CODE, u.ROLE_CODE, u.OBTAIN_DATE, u.CHANGE_DESC, u.CREATE_DATE, u.CREATOR, u.UPDATOR, u.UPDATE_DATE from F_USERROLE u where u.id.userCode=:userCode and u.id.roleCode = :roleCode ORDER BY obtainDate";
        String hql = "FROM UserRole ur where ur.id.userCode=? and ur.id.roleCode = ? ORDER BY obtainDate";
        List urlt = this.listObjectsBySql(sql, CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "roleCode", rolecode}));
        if (CollectionUtils.isEmpty((Collection)urlt)) {
            return null;
        }
        return (UserRole)urlt.get(0);
    }

    public void updateUserRole(UserRole userRole) {
        super.updateObject((Serializable)userRole);
    }

    public void mergeUserRole(UserRole dbUserRole) {
        super.mergeObject((Serializable)dbUserRole);
    }
}

