/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserQueryFilterDao;
import com.centit.framework.system.po.UserQueryFilter;
import com.centit.support.algorithm.CollectionsOpt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userQueryFilterDao")
public class UserQueryFilterDaoImpl
extends BaseDaoImpl<UserQueryFilter, Long>
implements UserQueryFilterDao {
    public static final Logger logger = LoggerFactory.getLogger(UserQueryFilterDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("filterNo", "EQUAL");
            this.filterField.put("userCode", "EQUAL");
            this.filterField.put("modleCode", "EQUAL");
            this.filterField.put("filterName", "EQUAL");
            this.filterField.put("filterValue", "EQUAL");
        }
        return this.filterField;
    }

    public void mergeUserFilter(UserQueryFilter userQueryFilter) {
        this.mergeObject((Serializable)userQueryFilter);
    }

    public UserQueryFilter getObjectById(Long filterNo) {
        return (UserQueryFilter)super.getObjectById((Object)filterNo);
    }

    @Transactional
    public List<UserQueryFilter> listUserQueryFilterByModle(String userCode, String modelCode) {
        return super.listObjectsByFilter(" where USER_CODE = ? and MODLE_CODE = ? order by IS_DEFAULT desc , CREATE_DATE desc", new Object[]{userCode, modelCode});
    }

    @Transactional
    public List<UserQueryFilter> listUserDefaultFilterByModle(String userCode, String modelCode) {
        return super.listObjectsByFilter(" where USER_CODE = ? and MODLE_CODE = ? and IS_DEFAULT = 'T' order by CREATE_DATE desc", new Object[]{userCode, modelCode});
    }

    @Transactional
    public UserQueryFilter getUserDefaultFilterByModle(String userCode, String modelCode) {
        return (UserQueryFilter)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "modelCode", modelCode}));
    }

    @Transactional
    public Long getNextKey() {
        return DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_FILTER_NO");
    }
}

