/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.InnerMsgRecipientDao;
import com.centit.framework.system.po.InnerMsgRecipient;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="innerMsgRecipientDao")
public class InnerMsgRecipientDaoImpl
extends BaseDaoImpl<InnerMsgRecipient, String>
implements InnerMsgRecipientDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("receive", "receive = :receive");
            this.filterField.put("sender", "msgCode in (select im.MSG_CODE from M_INNERMSG im where im.SENDER = :sender )");
            this.filterField.put("(like)msgContent", "msgCode in (select im.MSG_CODE from M_INNERMSG im where im.MSG_CONTENT LIKE :msgContent )");
            this.filterField.put("(like)msgTitle", "msgCode in (select im.MSG_CODE from M_INNERMSG im where im.MSG_TITLE LIKE :msgTitle )");
            this.filterField.put("mailType", "msgCode in (select im.MSG_CODE from M_INNERMSG im where im.MAIL_TYPE = :mailType )");
            this.filterField.put("mailTypeNot", "msgCode in (select im.MSG_CODE from M_INNERMSG im where im.MAIL_TYPE != :mailTypeNot )");
            this.filterField.put("msgStateNot", "msgState != :msgStateNot");
            this.filterField.put("innerMsgStateNot", "msgCode in (select im.MSG_CODE from M_INNERMSG im where im.MSG_STATE != :innerMsgStateNot )");
            this.filterField.put("isRecycled", "EQUAL");
            this.filterField.put("MSGSTATE", "EQUAL");
            this.filterField.put("msgType", "msgCode in ( select im.MSG_CODE from M_INNERMSG im where im.MSG_TYPE = :msgType )");
        }
        return this.filterField;
    }

    public List<InnerMsgRecipient> listObjects(Map<String, Object> filterMap) {
        return super.listObjectsByProperties(filterMap);
    }

    public InnerMsgRecipient getObjectById(String id) {
        return (InnerMsgRecipient)super.getObjectById((Object)id);
    }

    @Transactional
    public List<InnerMsgRecipient> getExchangeMsgs(String sender, String receiver) {
        String queryString = "where( (MSG_CODE in (Select im.MSG_CODE from M_INNERMSG im where im.SENDER= ?  and (im.MAIL_TYPE='I' or im.MAIL_TYPE='O')) and RECEIVE= ?) or (MSG_CODE in(Select  im.MSG_CODE from M_INNERMSG im where im.sender= ?  and (im.MAIL_TYPE='I' or im.MAIL_TYPE='O')) and RECEIVE= ? )) order by msgCode desc";
        List l = this.listObjectsByFilter(queryString, new Object[]{sender, receiver, receiver, sender});
        return l;
    }

    public long getUnreadMessageCount(String userCode) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(1) Where receive = ? and msgState ='U'", (Object[])new Object[]{userCode});
        Long l = NumberBaseOpt.castObjectToLong((Object)obj);
        return l == null ? 0L : l;
    }

    public List<InnerMsgRecipient> listUnreadMessage(String userCode) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"receive", userCode, "msgState", "U"}));
    }

    public void updateInnerMsgRecipient(InnerMsgRecipient innerMsgRecipient) {
        super.updateObject((Serializable)innerMsgRecipient);
    }

    @Transactional
    public String getNextKey() {
        return StringBaseOpt.objectToString((Object)DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_RECIPIENT"));
    }
}

