/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.security;

import com.centit.support.algorithm.StringBaseOpt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.ConfigAttribute;

public class OptTreeNode
implements Serializable {
    public List<ConfigAttribute> roleList = new ArrayList<ConfigAttribute>();
    public Map<String, OptTreeNode> childList = null;

    public List<ConfigAttribute> getRoleList() {
        return this.roleList;
    }

    public void addRoleList(List<ConfigAttribute> attributes) {
        if (attributes == null) {
            return;
        }
        if (this.roleList == null) {
            this.roleList = attributes;
        } else {
            for (ConfigAttribute role : attributes) {
                if (this.roleList.contains(role)) continue;
                this.roleList.add(role);
            }
        }
        if (this.roleList != null) {
            this.roleList.sort(Comparator.comparing(ConfigAttribute::getAttribute));
        }
    }

    public Map<String, OptTreeNode> getChildList() {
        return this.childList;
    }

    public OptTreeNode setChildPath(String surl) {
        OptTreeNode child;
        if (this.childList == null) {
            this.childList = new HashMap<String, OptTreeNode>();
        }
        if ((child = this.childList.get(surl)) == null) {
            child = new OptTreeNode();
            this.childList.put(surl, child);
        }
        return child;
    }

    private void printTreeNode(OptTreeNode treeNode, int n) {
        if (treeNode.getChildList() == null) {
            return;
        }
        for (Map.Entry<String, OptTreeNode> child : treeNode.getChildList().entrySet()) {
            System.out.println(StringBaseOpt.multiplyString((String)"  ", (int)n) + child.getKey() + ":" + StringBaseOpt.castObjectToString(child.getValue().getRoleList()));
            this.printTreeNode(child.getValue(), n + 1);
        }
    }

    public void printTreeNode() {
        System.out.println(StringBaseOpt.castObjectToString(this.roleList));
        this.printTreeNode(this, 1);
        System.out.println("--------------------------------");
    }

    public List<List<String>> parsePowerDefineUrl(String sOptDefUrl, String sMethod) {
        String[] sUrls = sOptDefUrl.split("/");
        ArrayList<String> sopts = new ArrayList<String>();
        for (String s : sUrls) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            sopts.add(s);
        }
        ArrayList<List<String>> swords = new ArrayList<List<String>>();
        if (sMethod.indexOf(67) >= 0) {
            ArrayList<String> fullOpts = new ArrayList<String>(sopts.size() + 2);
            fullOpts.add("POST");
            fullOpts.addAll(sopts);
            swords.add(fullOpts);
        }
        if (sMethod.indexOf(68) >= 0) {
            ArrayList<String> fullOpts = new ArrayList<String>(sopts.size() + 2);
            fullOpts.add("DELETE");
            fullOpts.addAll(sopts);
            swords.add(fullOpts);
        }
        if (sMethod.indexOf(82) >= 0) {
            ArrayList<String> fullOpts = new ArrayList<String>(sopts.size() + 2);
            fullOpts.add("GET");
            fullOpts.addAll(sopts);
            swords.add(fullOpts);
        }
        if (sMethod.indexOf(85) >= 0) {
            ArrayList<String> fullOpts = new ArrayList<String>(sopts.size() + 2);
            fullOpts.add("PUT");
            fullOpts.addAll(sopts);
            swords.add(fullOpts);
        }
        return swords;
    }
}

