/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.security;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CentitUserDetails
implements Authentication,
UserDetails,
Serializable {
    private static final long serialVersionUID = 20181227L;
    private String loginIp;
    private Map<String, String> userSettings;
    private Map<String, String> userOptList;
    protected UserInfo userInfo;
    private List<UserRole> userRoles;
    private List<UserUnit> userUnits;
    private String topUnitCode;
    private String topUnitName;
    private String currentUnitName;
    private String tenantRole;
    @JSONField(serialize=false)
    private transient List<GrantedAuthority> arrayAuths;

    @JSONField(serialize=false)
    public String getUserCode() {
        if (this.userInfo == null) {
            return null;
        }
        return this.userInfo.getUserCode();
    }

    public boolean isEnabled() {
        return StringUtils.equalsAny((CharSequence)this.getUserInfo().getIsValid(), (CharSequence[])new CharSequence[]{"T", "W"});
    }

    protected void makeUserAuthorities() {
        if (this.userRoles == null) {
            return;
        }
        this.arrayAuths = new ArrayList<GrantedAuthority>();
        for (UserRole role : this.userRoles) {
            this.arrayAuths.add((GrantedAuthority)new SimpleGrantedAuthority("R_" + StringUtils.trim((String)role.getRoleCode())));
        }
        Collections.sort(this.arrayAuths, Comparator.comparing(GrantedAuthority::getAuthority));
    }

    public void addAuthorities(GrantedAuthority ga) {
        SimpleGrantedAuthority sga;
        String sRole = ga.getAuthority();
        if (!sRole.startsWith("R_")) {
            sRole = "R_" + sRole;
        }
        if (this.arrayAuths.contains(sga = new SimpleGrantedAuthority(sRole))) {
            return;
        }
        this.arrayAuths.add((GrantedAuthority)sga);
        Collections.sort(this.arrayAuths, Comparator.comparing(GrantedAuthority::getAuthority));
    }

    public String getTopUnitName() {
        return this.topUnitName;
    }

    public void setTopUnitName(String topUnitName) {
        this.topUnitName = topUnitName;
    }

    public String getCurrentUnitName() {
        return this.currentUnitName;
    }

    public void setCurrentUnitName(String currentUnitName) {
        this.currentUnitName = currentUnitName;
    }

    public String getTenantRole() {
        return this.tenantRole;
    }

    public void setTenantRole(String tenantRole) {
        this.tenantRole = tenantRole;
    }

    @JSONField(serialize=false)
    public UserUnit getCurrentStation() {
        List<UserUnit> uus = this.getUserUnits();
        String currentStationId = this.userInfo.getCurrentStationId();
        if (uus != null) {
            if (StringUtils.isNotBlank((CharSequence)currentStationId)) {
                for (UserUnit userUnit : uus) {
                    if (!StringUtils.equals((CharSequence)currentStationId, (CharSequence)userUnit.getUserUnitId())) continue;
                    return userUnit;
                }
            }
            for (UserUnit userUnit : uus) {
                if (!"T".equals(userUnit.getRelType())) continue;
                return userUnit;
            }
            if (uus.size() > 0) {
                return uus.get(0);
            }
        }
        return null;
    }

    public void setCurrentStationId(String userUnitId) {
        this.userInfo.setCurrentStationId(userUnitId);
    }

    public String getCurrentStationId() {
        return this.userInfo.getCurrentStationId();
    }

    public String getCurrentUnitCode() {
        UserUnit cs = this.getCurrentStation();
        return cs != null ? cs.getUnitCode() : this.getUserInfo().getPrimaryUnit();
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public void setTopUnitCode(String topUnitCode) {
        this.topUnitCode = topUnitCode;
    }

    public String getTopUnitCode() {
        return this.topUnitCode;
    }

    @JSONField(serialize=false)
    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.arrayAuths == null || this.arrayAuths.size() == 0) {
            this.makeUserAuthorities();
        }
        return this.arrayAuths;
    }

    @JSONField(serialize=false)
    public String getPassword() {
        return this.getUserInfo().getUserPin();
    }

    public String getUsername() {
        return this.getUserInfo().getLoginName();
    }

    public boolean isAccountNonExpired() {
        return this.isEnabled();
    }

    public boolean isAccountNonLocked() {
        return this.isEnabled();
    }

    public boolean isCredentialsNonExpired() {
        return this.isEnabled();
    }

    public void setUserSettings(Map<String, String> userSettings) {
        this.userSettings = userSettings;
    }

    public void putUserSettingsParams(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public Map<String, String> getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>(2);
        }
        return this.userSettings;
    }

    public String getUserSettingValue(String paramCode) {
        if (this.userSettings == null) {
            return null;
        }
        return this.userSettings.get(paramCode);
    }

    public void setUserSettingValue(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>(10);
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public void setUserOptList(Map<String, String> userOptList) {
        this.userOptList = userOptList;
    }

    public Map<String, String> getUserOptList() {
        if (this.userOptList == null) {
            this.userOptList = new HashMap<String, String>(10);
        }
        return this.userOptList;
    }

    public boolean checkOptPower(String optId, String optMethod) {
        String s = this.userOptList.get(optId + "-" + optMethod);
        return s != null;
    }

    @JSONField(serialize=false)
    public Object getCredentials() {
        return this.getUserInfo().getUserPin();
    }

    @JSONField(serialize=false)
    public Object getDetails() {
        return this;
    }

    @JSONField(serialize=false)
    public Object getPrincipal() {
        return this;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.getUserInfo().getLoginName();
    }

    public boolean equals(Object other) {
        if (other instanceof CentitUserDetails) {
            return this.getUserInfo().getUserCode().equals(((CentitUserDetails)other).getUserInfo().getUserCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getUserInfo().getUserCode().hashCode();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public List<UserRole> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(List<UserRole> roles) {
        this.setAuthoritiesByRoles(roles);
    }

    public void setAuthoritiesByRoles(List<UserRole> roles) {
        this.userRoles = roles;
        this.makeUserAuthorities();
    }

    public void mapAuthoritiesByRoles(List<RoleInfo> roles) {
        this.userRoles = new ArrayList<UserRole>();
        if (roles != null) {
            Date yesterday = DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)-1);
            for (RoleInfo ri : roles) {
                UserRole ur = new UserRole(new UserRoleId(this.getUserCode(), ri.getRoleCode()), yesterday, "\u89d2\u8272\u6620\u5c04");
                this.userRoles.add(ur);
            }
            this.makeUserAuthorities();
        }
    }

    public List<UserUnit> getUserUnits() {
        return this.userUnits;
    }

    public void setUserUnits(List<UserUnit> userUnits) {
        this.userUnits = userUnits;
    }

    public JSONObject toJsonWithoutSensitive() {
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)this);
        jsonObject.put((Object)"userInfo", (Object)this.userInfo.toJsonWithoutSensitive());
        return jsonObject;
    }
}

