/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.basedata;

import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.model.basedata.RolePowerId;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_ROLEPOWER")
@ApiModel(value="\u7cfb\u7edf\u89d2\u8272\u64cd\u4f5c\u6743\u9650\u5bf9\u8c61", description="\u7cfb\u7edf\u89d2\u8272\u64cd\u4f5c\u6743\u9650\u5bf9\u8c61 RolePower")
public class RolePower
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(serialize=false, deserialize=false)
    @EmbeddedId
    private RolePowerId id;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    protected Date createDate;
    @Column(name="OPT_SCOPE_CODES")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e{max}")
    private @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e{max}") String optScopeCodes;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="UPDATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String updator;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    private String topUnit;

    public String getTopUnit() {
        return this.topUnit;
    }

    public void setTopUnit(String topUnit) {
        this.topUnit = topUnit;
    }

    public RolePower() {
    }

    public RolePower(RolePowerId id) {
        this.id = id;
        this.createDate = DatetimeOpt.currentUtilDate();
    }

    public RolePower(RolePowerId id, String optScopeCodes) {
        this.id = id;
        this.optScopeCodes = optScopeCodes;
        this.createDate = DatetimeOpt.currentUtilDate();
    }

    public RolePowerId getId() {
        return this.id;
    }

    public void setId(RolePowerId id) {
        this.id = id;
    }

    public String getRoleCode() {
        if (this.id == null) {
            this.id = new RolePowerId();
        }
        return this.id.getRoleCode();
    }

    public void setRoleCode(String rolecode) {
        if (this.id == null) {
            this.id = new RolePowerId();
        }
        this.id.setRoleCode(rolecode);
    }

    public String getOptCode() {
        if (this.id == null) {
            this.id = new RolePowerId();
        }
        return this.id.getOptCode();
    }

    public void setOptCode(String optcode) {
        if (this.id == null) {
            this.id = new RolePowerId();
        }
        this.id.setOptCode(optcode);
    }

    public String getOptScopeCodes() {
        return this.optScopeCodes;
    }

    public String[] getOptScopeCodeSet() {
        if (this.optScopeCodes == null) {
            return null;
        }
        return this.optScopeCodes.split(",");
    }

    public void setOptScopeCodes(String optScopeCodes) {
        this.optScopeCodes = optScopeCodes;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof RolePower)) {
            return false;
        }
        return this.getId().equals(((RolePower)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getLastModifyDate() {
        return this.updateDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.updateDate = lastModifyDate;
    }
}

