/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.basedata;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.RolePower;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="F_ROLEINFO")
@ApiModel(value="\u7cfb\u7edf\u89d2\u8272\u4fe1\u606f\u5bf9\u8c61", description="\u7cfb\u7edf\u89d2\u8272\u4fe1\u606f\u5bf9\u8c61 RoleInfo")
public class RoleInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ROLE_CODE")
    @ValueGenerator(strategy=GeneratorType.RANDOM_ID, value="7:R")
    @ApiModelProperty(value="\u89d2\u8272\u4ee3\u7801,\u53ef\u4ee5\u9009\u62e9\u4e0d\u586b\u540e\u53f0\u81ea\u52a8\u751f\u6210", name="roleCode")
    private String roleCode;
    @Column(name="ROLE_NAME")
    @Length(max=300, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u89d2\u8272\u540d\u79f0", name="roleName", required=true)
    private @Length(max=300, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String roleName;
    @Column(name="IS_VALID")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="T")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @Pattern(regexp="[TFA]", message="\u5b57\u6bb5\u503c\u5fc5\u987b\u662fT\u6216F,A\u4e3a\u65b0\u5efa\u53ef\u4ee5\u5220\u9664")
    @ApiModelProperty(value="\u662f\u5426\u751f\u6548 T:\u751f\u6548 F:\u5931\u6548 A:\u65b0\u5efa\u53ef\u4ee5\u5220\u9664", name="isValid", required=true)
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") @Pattern(regexp="[TFA]", message="\u5b57\u6bb5\u503c\u5fc5\u987b\u662fT\u6216F,A\u4e3a\u65b0\u5efa\u53ef\u4ee5\u5220\u9664") String isValid;
    @Column(name="ROLE_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @ApiModelProperty(value="\u89d2\u8272\u7684\u7c7b\u522b F:\u7cfb\u7edf\u5185\u7f6e\u7684 G:\u5168\u5c40\u7684 P:\u516c\u7528\u7684 D:\u90e8\u95e8\uff08\u673a\u6784\uff09\u7279\u6709\u7684\u89d2\u8272 I:\u9879\u76ee\u89d2\u8272 W:\u5de5\u4f5c\u6d41\u89d2\u8272", name="roleType", required=true)
    @DictionaryMap(fieldName={"roleTypeText"}, value={"RoleType"})
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String roleType;
    @Column(name="UNIT_CODE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"topUnitName"}, value={"unitCode"})
    @ApiModelProperty(value="topUnit \u79df\u6237\u4ee3\u7801", name="unitCode")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitCode;
    @Column(name="OS_ID")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u89d2\u8272\u6240\u5c5e\u9879\u76ee", name="osId")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String osId;
    @Column(name="ROLE_DESC")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String roleDesc;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="UPDATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String updator;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW, value="today()")
    protected Date createDate;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    @Transient
    private List<RolePower> rolePowers;

    public RoleInfo() {
        this.roleType = "G";
    }

    public RoleInfo(String rolecode, String isvalid) {
        this.roleCode = rolecode;
        this.isValid = isvalid;
        this.roleType = "G";
    }

    public RoleInfo(String rolecode, String rolename, String roleType, String unitCode, String isvalid, String roledesc) {
        this.roleCode = rolecode;
        this.roleName = rolename;
        this.roleType = roleType;
        this.unitCode = unitCode;
        this.isValid = isvalid;
        this.roleDesc = roledesc;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String rolecode) {
        this.roleCode = rolecode;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String rolename) {
        this.roleName = rolename;
    }

    public String toString() {
        return this.roleName;
    }

    public String getIsValid() {
        return this.isValid;
    }

    public void setIsValid(String isvalid) {
        this.isValid = isvalid;
    }

    public String getRoleDesc() {
        return this.roleDesc;
    }

    public void setRoleDesc(String roledesc) {
        this.roleDesc = roledesc;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public Date getLastModifyDate() {
        return this.updateDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.updateDate = lastModifyDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public List<RolePower> getRolePowers() {
        if (null == this.rolePowers) {
            this.rolePowers = new ArrayList<RolePower>();
        }
        return this.rolePowers;
    }

    public void setRolePowers(List<RolePower> rolePowers) {
        this.rolePowers = rolePowers;
    }

    public void addAllRolePowers(List<RolePower> rolePowers) {
        this.getRolePowers().clear();
        if (CollectionUtils.isEmpty(rolePowers)) {
            return;
        }
        this.getRolePowers().addAll(rolePowers);
    }

    public void addRolePower(RolePower rp) {
        this.getRolePowers().add(rp);
    }
}

