/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.mybatis.plugin;

import com.centit.framework.mybatis.plugin.QueryAndParamMaps;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class ParameterDriverSqlInterceptor
implements Interceptor {
    private static final String PARAMETER_DRIVER_SQL_SUFFIX = "ByPDSql";

    public Object intercept(Invocation invocation) throws Throwable {
        Lexer lexer;
        String aword;
        Object obj;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaStmtHandler = SystemMetaObject.forObject((Object)statementHandler);
        while (metaStmtHandler.hasGetter("h")) {
            obj = metaStmtHandler.getValue("h");
            metaStmtHandler = SystemMetaObject.forObject((Object)obj);
        }
        while (metaStmtHandler.hasGetter("target")) {
            obj = metaStmtHandler.getValue("target");
            metaStmtHandler = SystemMetaObject.forObject((Object)obj);
        }
        MappedStatement mappedStatement = (MappedStatement)metaStmtHandler.getValue("delegate.mappedStatement");
        BoundSql boundSql = statementHandler.getBoundSql();
        String nativeSql = boundSql.getSql();
        String mapId = mappedStatement.getId();
        boolean isPDSql = mapId.endsWith(PARAMETER_DRIVER_SQL_SUFFIX);
        if (!isPDSql && ("--".equals(aword = (lexer = new Lexer(nativeSql, 2)).getARegularWord()) || "/*".equals(aword))) {
            aword = lexer.getARegularWord();
            if ("PDSql".equals(aword)) {
                isPDSql = true;
            } else if (("parameter".equalsIgnoreCase(aword) || "parameters".equalsIgnoreCase(aword)) && "driver".equalsIgnoreCase(aword = lexer.getARegularWord()) && "sql".equalsIgnoreCase(aword = lexer.getARegularWord())) {
                isPDSql = true;
            }
        }
        if (!isPDSql) {
            return invocation.proceed();
        }
        Map<String, Object> parameterObjectMap = QueryAndParamMaps.parameterObjectMap(boundSql.getParameterObject());
        Object filter = parameterObjectMap.get("powerFilter");
        QueryAndParamMaps qandP = QueryAndParamMaps.createFromQueryAndNamedParams(QueryUtils.translateQuery((String)nativeSql, QueryAndParamMaps.objectToStringList(filter), parameterObjectMap, (boolean)true));
        metaStmtHandler.setValue("delegate.boundSql.sql", (Object)qandP.getQuery());
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>(qandP.getParamNames().size());
        for (String sname : qandP.getParamNames()) {
            parameterMappings.add(new ParameterMapping.Builder(mappedStatement.getConfiguration(), sname, Object.class).build());
        }
        metaStmtHandler.setValue("delegate.boundSql.parameterMappings", parameterMappings);
        parameterObjectMap.putAll(qandP.getNamedParams());
        metaStmtHandler.setValue("delegate.boundSql.parameterObject", parameterObjectMap);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

