/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.mybatis.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.database.jsonmaptable.DB2JsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.jsonmaptable.MySqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.OracleJsonObjectDao;
import com.centit.support.database.jsonmaptable.SqlSvrJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;

public class JsonObjectWork
implements JsonObjectDao {
    private TableInfo tableInfo;
    private SqlSession sqlSession;
    private JsonObjectDao currentDao = null;

    public JsonObjectWork() {
    }

    public JsonObjectWork(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public JsonObjectWork(SqlSession sqlSession, TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.sqlSession = sqlSession;
    }

    public void setBaseDao(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public JsonObjectDao createDao(Connection connection) {
        DBType dbtype = DBType.mapDBType((Connection)connection);
        switch (dbtype) {
            case Oracle: {
                return new OracleJsonObjectDao(connection, this.tableInfo);
            }
            case DB2: {
                return new DB2JsonObjectDao(connection, this.tableInfo);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(connection, this.tableInfo);
            }
            case MySql: {
                return new MySqlJsonObjectDao(connection, this.tableInfo);
            }
        }
        return new OracleJsonObjectDao(connection, this.tableInfo);
    }

    public JsonObjectDao getCurrentDao() {
        if (this.currentDao == null) {
            this.currentDao = this.createDao(this.sqlSession.getConnection());
        }
        return this.currentDao;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        return this.getCurrentDao().getObjectById(keyValue);
    }

    public JSONObject getObjectById(Map<String, Object> keyValues) throws SQLException, IOException {
        return this.getCurrentDao().getObjectById(keyValues);
    }

    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        return this.getCurrentDao().getObjectByProperties(properties);
    }

    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        return this.getCurrentDao().listObjectsByProperties(properties);
    }

    public JSONArray listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) throws SQLException, IOException {
        return this.getCurrentDao().listObjectsByProperties(properties, startPos, maxSize);
    }

    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        return this.getCurrentDao().fetchObjectsCount(properties);
    }

    public int saveNewObject(Map<String, Object> object) throws SQLException {
        return this.getCurrentDao().saveNewObject(object);
    }

    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        return this.getCurrentDao().updateObject(fields, object);
    }

    public int updateObject(Map<String, Object> object) throws SQLException {
        return this.getCurrentDao().updateObject(object);
    }

    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        return this.getCurrentDao().mergeObject(fields, object);
    }

    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return this.getCurrentDao().mergeObject(object);
    }

    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return this.getCurrentDao().updateObjectsByProperties(fieldValues, properties);
    }

    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return this.getCurrentDao().updateObjectsByProperties(fields, fieldValues, properties);
    }

    public int deleteObjectById(Object keyValue) throws SQLException {
        return this.getCurrentDao().deleteObjectById(keyValue);
    }

    public int deleteObjectById(Map<String, Object> keyValues) throws SQLException {
        return this.getCurrentDao().deleteObjectById(keyValues);
    }

    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        return this.getCurrentDao().deleteObjectsByProperties(properties);
    }

    public int insertObjectsAsTabulation(JSONArray objects) throws SQLException {
        return this.getCurrentDao().insertObjectsAsTabulation(objects);
    }

    public int deleteObjects(JSONArray objects) throws SQLException {
        return this.getCurrentDao().deleteObjects(objects);
    }

    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        return this.getCurrentDao().deleteObjectsAsTabulation(propertyName, propertyValue);
    }

    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        return this.getCurrentDao().deleteObjectsAsTabulation(properties);
    }

    public int replaceObjectsAsTabulation(JSONArray newObjects, JSONArray dbObjects) throws SQLException {
        return this.getCurrentDao().replaceObjectsAsTabulation(newObjects, dbObjects);
    }

    public int replaceObjectsAsTabulation(JSONArray newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        return this.getCurrentDao().replaceObjectsAsTabulation(newObjects, propertyName, propertyValue);
    }

    public int replaceObjectsAsTabulation(JSONArray newObjects, Map<String, Object> properties) throws SQLException, IOException {
        return this.getCurrentDao().replaceObjectsAsTabulation(newObjects, properties);
    }

    public Long getSequenceNextValue(String sequenceName) throws SQLException, IOException {
        return this.getCurrentDao().getSequenceNextValue(sequenceName);
    }

    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsBySql(sSql, values);
    }

    public List<Object[]> findObjectsBySql(String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsBySql(sSql, values, pageNo, pageSize);
    }

    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsByNamedSql(sSql, values);
    }

    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsByNamedSql(sSql, values, pageNo, pageSize);
    }

    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsAsJSON(sSql, values, fieldnames);
    }

    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsAsJSON(sSql, values, fieldnames, pageNo, pageSize);
    }

    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsByNamedSqlAsJSON(sSql, values, fieldnames);
    }

    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        return this.getCurrentDao().findObjectsByNamedSqlAsJSON(sSql, values, fieldnames, pageNo, pageSize);
    }

    public boolean doExecuteSql(String sSql) throws SQLException {
        return this.getCurrentDao().doExecuteSql(sSql);
    }

    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        return this.getCurrentDao().doExecuteSql(sSql, values);
    }

    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        return this.getCurrentDao().doExecuteNamedSql(sSql, values);
    }
}

