/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.mybatis.dao;

import com.centit.support.database.ddl.DB2DDLOperations;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.MySqlDDLOperations;
import com.centit.support.database.ddl.OracleDDLOperations;
import com.centit.support.database.ddl.SqlSvrDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.session.SqlSession;

public class DDLOperationsWork
implements DDLOperations {
    private SqlSession sqlSession;
    private DDLOperations operations = null;

    public DDLOperationsWork() {
    }

    public DDLOperationsWork(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public void setBaseDao(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public static DDLOperations createDDLOpt(Connection connection) {
        DBType dbtype = DBType.mapDBType((Connection)connection);
        switch (dbtype) {
            case Oracle: {
                return new OracleDDLOperations(connection);
            }
            case DB2: {
                return new DB2DDLOperations(connection);
            }
            case SqlServer: {
                return new SqlSvrDDLOperations(connection);
            }
            case MySql: {
                return new MySqlDDLOperations(connection);
            }
        }
        return new OracleDDLOperations(connection);
    }

    public DDLOperations getDDLOperations() {
        if (this.operations == null) {
            this.operations = DDLOperationsWork.createDDLOpt(this.sqlSession.getConnection());
        }
        return this.operations;
    }

    public void createSequence(String sequenceName) throws SQLException {
        this.getDDLOperations().createSequence(sequenceName);
    }

    public void createTable(TableInfo tableInfo) throws SQLException {
        this.getDDLOperations().createTable(tableInfo);
    }

    public void dropTable(String tableCode) throws SQLException {
        this.getDDLOperations().dropTable(tableCode);
    }

    public void addColumn(String tableCode, TableField column) throws SQLException {
        this.getDDLOperations().addColumn(tableCode, column);
    }

    public void modifyColumn(String tableCode, TableField column) throws SQLException {
        this.getDDLOperations().modifyColumn(tableCode, column);
    }

    public void dropColumn(String tableCode, String columnCode) throws SQLException {
        this.getDDLOperations().dropColumn(tableCode, columnCode);
    }

    public void renameColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        this.getDDLOperations().renameColumn(tableCode, columnCode, column);
    }

    public void reconfigurationColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        this.getDDLOperations().reconfigurationColumn(tableCode, columnCode, column);
    }

    public String makeCreateSequenceSql(String sequenceName) {
        return this.getDDLOperations().makeCreateSequenceSql(sequenceName);
    }

    public String makeCreateTableSql(TableInfo tableInfo) {
        return this.getDDLOperations().makeCreateTableSql(tableInfo);
    }

    public String makeDropTableSql(String tableCode) {
        return this.getDDLOperations().makeDropTableSql(tableCode);
    }

    public String makeAddColumnSql(String tableCode, TableField column) {
        return this.getDDLOperations().makeAddColumnSql(tableCode, column);
    }

    public String makeModifyColumnSql(String tableCode, TableField column) {
        return this.getDDLOperations().makeModifyColumnSql(tableCode, column);
    }

    public String makeDropColumnSql(String tableCode, String columnCode) {
        return this.getDDLOperations().makeDropColumnSql(tableCode, columnCode);
    }

    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        return this.getDDLOperations().makeRenameColumnSql(tableCode, columnCode, column);
    }

    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        return this.getDDLOperations().makeReconfigurationColumnSqls(tableCode, columnCode, column);
    }
}

