/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.flyway.plugin;

import com.centit.framework.flyway.plugin.DbMigrateExt;
import com.centit.framework.flyway.plugin.DbSupportFactoryExt;
import com.centit.framework.flyway.plugin.MetaDataExtTableImpl;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.SqlScriptFlywayCallback;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.util.ConfigurationInjectionUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.VersionPrinter;
import org.flywaydb.core.internal.util.jdbc.JdbcUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class FlywayExt
extends Flyway {
    private static final Log LOG = LogFactory.getLog(FlywayExt.class);
    private Locations locations = new Locations(new String[]{"db/migration"});

    public void setLocations(String ... locations) {
        this.locations = new Locations(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Command<T> command) {
        T result;
        VersionPrinter.printVersion();
        Connection connectionMetaDataTable = null;
        try {
            if (this.getDataSource() == null) {
                throw new FlywayException("Unable to connect to the database. Configure the url, user and password!");
            }
            connectionMetaDataTable = JdbcUtils.openConnection((DataSource)this.getDataSource());
            DbSupport dbSupport = DbSupportFactoryExt.createDbSupport(connectionMetaDataTable, false);
            LOG.debug("DDL Transactions Supported: " + dbSupport.supportsDdlTransactions());
            if (this.getSchemas().length == 0) {
                Schema currentSchema = dbSupport.getOriginalSchema();
                if (currentSchema == null) {
                    throw new FlywayException("Unable to determine schema for the metadata table. Set a default schema for the connection or specify one using the schemas property!");
                }
                this.setSchemas(new String[]{currentSchema.getName()});
            }
            if (this.getSchemas().length == 1) {
                LOG.debug("Schema: " + this.getSchemas()[0]);
            } else {
                LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString((Object[])this.getSchemas()));
            }
            Schema[] schemas = new Schema[this.getSchemas().length];
            for (int i = 0; i < this.getSchemas().length; ++i) {
                schemas[i] = dbSupport.getSchema(this.getSchemas()[i]);
            }
            Scanner scanner = new Scanner(this.getClassLoader());
            MigrationResolver migrationResolver = this.createMigrationResolver(dbSupport, scanner);
            if (!this.isSkipDefaultCallbacks()) {
                LinkedHashSet<FlywayCallback> flywayCallbacks = new LinkedHashSet<FlywayCallback>(Arrays.asList(this.getCallbacks()));
                flywayCallbacks.add((FlywayCallback)new SqlScriptFlywayCallback(dbSupport, scanner, this.locations, this.createPlaceholderReplacer(), (FlywayConfiguration)this));
                this.setCallbacks(flywayCallbacks.toArray(new FlywayCallback[flywayCallbacks.size()]));
            }
            for (FlywayCallback callback : this.getCallbacks()) {
                ConfigurationInjectionUtils.injectFlywayConfiguration((Object)callback, (FlywayConfiguration)this);
            }
            MetaDataExtTableImpl metaDataTable = new MetaDataExtTableImpl(dbSupport, schemas[0].getTable(this.getTable()), this.getInstalledBy());
            if (metaDataTable.upgradeIfNecessary()) {
                new DbRepair(dbSupport, connectionMetaDataTable, schemas[0], migrationResolver, (MetaDataTable)metaDataTable, this.getCallbacks()).repairChecksumsAndDescriptions();
                LOG.info("Metadata table " + this.getTable() + " successfully upgraded to the Flyway 4.0 format.");
            }
            result = command.execute(connectionMetaDataTable, migrationResolver, (MetaDataTable)metaDataTable, dbSupport, schemas, this.getCallbacks());
        }
        catch (Throwable throwable) {
            JdbcUtils.closeConnection(connectionMetaDataTable);
            throw throwable;
        }
        JdbcUtils.closeConnection((Connection)connectionMetaDataTable);
        return result;
    }

    private MigrationResolver createMigrationResolver(DbSupport dbSupport, Scanner scanner) {
        for (MigrationResolver resolver : this.getResolvers()) {
            ConfigurationInjectionUtils.injectFlywayConfiguration((Object)resolver, (FlywayConfiguration)this);
        }
        return new CompositeMigrationResolver(dbSupport, scanner, (FlywayConfiguration)this, this.locations, this.createPlaceholderReplacer(), this.getResolvers());
    }

    private PlaceholderReplacer createPlaceholderReplacer() {
        if (this.isPlaceholderReplacement()) {
            return new PlaceholderReplacer(this.getPlaceholders(), this.getPlaceholderPrefix(), this.getPlaceholderSuffix());
        }
        return PlaceholderReplacer.NO_PLACEHOLDERS;
    }

    public int migrate() throws FlywayException {
        return this.execute((connectionMetaDataTable, migrationResolver, metaDataTable, dbSupport, schemas, flywayCallbacks) -> {
            new DbSchemas(connectionMetaDataTable, schemas, metaDataTable).create();
            if (!metaDataTable.exists()) {
                ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                for (Schema schema : schemas) {
                    if (schema.empty()) continue;
                    nonEmptySchemas.add(schema);
                }
                if (!nonEmptySchemas.isEmpty()) {
                    if (this.isBaselineOnMigrate()) {
                        new DbBaseline(connectionMetaDataTable, dbSupport, metaDataTable, schemas[0], this.getBaselineVersion(), this.getBaselineDescription(), flywayCallbacks).baseline();
                    } else if (!metaDataTable.exists()) {
                        throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without metadata table! Use baseline() or set baselineOnMigrate to true to initialize the metadata table.");
                    }
                }
            }
            Connection connectionUserObjects = null;
            try {
                connectionUserObjects = dbSupport.useSingleConnection() ? connectionMetaDataTable : JdbcUtils.openConnection((DataSource)this.getDataSource());
                DbMigrateExt dbMigrate = new DbMigrateExt(connectionUserObjects, dbSupport, metaDataTable, schemas[0], migrationResolver, this.isIgnoreFutureMigrations(), (FlywayConfiguration)this);
                Integer n = dbMigrate.migrate();
                return n;
            }
            finally {
                if (!dbSupport.useSingleConnection()) {
                    JdbcUtils.closeConnection((Connection)connectionUserObjects);
                }
            }
        });
    }

    static interface Command<T> {
        public T execute(Connection var1, MigrationResolver var2, MetaDataTable var3, DbSupport var4, Schema[] var5, FlywayCallback[] var6);
    }
}

