/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.po;

import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.core.po.EntityWithTimestamp;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.security.AESSecurityUtils;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_DATABASE_INFO")
public class DatabaseInfo
implements EntityWithTimestamp,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DESKEY = "0123456789abcdefghijklmnopqrstuvwxyzABCDEF";
    @Id
    @Column(name="DATABASE_CODE")
    private String databaseCode;
    @Column(name="OS_ID")
    private String osId;
    @Column(name="DATABASE_NAME")
    private String databaseName;
    @Column(name="DATABASE_URL")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String databaseUrl;
    @Column(name="USERNAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String username;
    @Column(name="PASSWORD")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String password;
    @Column(name="DATABASE_DESC")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String databaseDesc;
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="now", condition=GeneratorCondition.ALWAYS, occasion=GeneratorTime.ALWAYS)
    @Column(name="LAST_MODIFY_DATE")
    private Date lastModifyDate;
    @Column(name="CREATED")
    private String created;
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="now")
    @Column(name="CREATE_TIME")
    private Date createTime;

    public DatabaseInfo() {
    }

    public DatabaseInfo(String databaseCode, String databaseName) {
        this.databaseCode = databaseCode;
        this.databaseName = databaseName;
    }

    public DatabaseInfo(String databaseCode, String databaseName, String databaseUrl, String username, String password, String dataDesc) {
        this.databaseCode = databaseCode;
        this.databaseName = databaseName;
        this.databaseUrl = databaseUrl;
        this.username = username;
        this.password = password;
        this.databaseDesc = dataDesc;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseDesc() {
        return this.databaseDesc;
    }

    public void setDatabaseDesc(String dataDesc) {
        this.databaseDesc = dataDesc;
    }

    public void copy(DatabaseInfo other) {
        this.databaseCode = other.getDatabaseCode();
        this.setDatabaseName(other.getDatabaseName());
        this.databaseUrl = other.getDatabaseUrl();
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.databaseDesc = other.getDatabaseDesc();
        this.osId = other.getOsId();
        this.created = other.getCreated();
        this.createTime = other.getCreateTime();
        this.lastModifyDate = other.getLastModifyDate();
    }

    public void copyNotNullProperty(DatabaseInfo other) {
        if (other.getDatabaseName() != null) {
            this.setDatabaseName(other.getDatabaseName());
        }
        if (other.getDatabaseCode() != null) {
            this.databaseCode = other.getDatabaseCode();
        }
        if (other.getDatabaseUrl() != null) {
            this.databaseUrl = other.getDatabaseUrl();
        }
        if (other.getUsername() != null) {
            this.username = other.getUsername();
        }
        if (other.getPassword() != null) {
            this.password = other.getPassword();
        }
        if (other.getDatabaseDesc() != null) {
            this.databaseDesc = other.getDatabaseDesc();
        }
        if (other.getOsId() != null) {
            this.osId = other.getOsId();
        }
        if (other.getCreated() != null) {
            this.created = other.getCreated();
        }
        if (other.getCreateTime() != null) {
            this.createTime = other.getCreateTime();
        }
        if (other.getLastModifyDate() != null) {
            this.lastModifyDate = other.getLastModifyDate();
        }
    }

    public void clearProperties() {
        this.databaseCode = null;
        this.databaseName = null;
        this.databaseUrl = null;
        this.lastModifyDate = null;
        this.osId = null;
        this.username = null;
        this.password = null;
        this.databaseDesc = null;
        this.created = null;
        this.createTime = null;
    }

    @JSONField(serialize=false)
    public String getClearPassword() {
        return AESSecurityUtils.decryptBase64String((String)this.getPassword(), (String)DESKEY);
    }

    public void setClearPassword(String clearPassword) {
        this.password = AESSecurityUtils.encryptAndBase64((String)clearPassword, (String)DESKEY);
    }
}

