/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.ip.service.DatabaseInfoManager;
import com.centit.framework.ip.service.OsInfoManager;
import com.centit.framework.ip.service.UserAccessTokenManager;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IUserSetting;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.algorithm.StringBaseOpt;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/platform"})
public class PlatformDataController
extends BaseController {
    @Resource
    @NotNull
    private UserSettingManager userSettingManager;
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource(name="platformEnvironment")
    @NotNull
    protected PlatformEnvironment platformEnvironment;
    @Resource
    @NotNull
    private SysUserManager sysUserManager;
    @Resource
    @NotNull
    protected OsInfoManager osInfoManager;
    @Resource
    @NotNull
    protected DatabaseInfoManager oatabaseInfoManager;
    @Resource
    @NotNull
    protected UserAccessTokenManager userAccessTokenManager;

    @RequestMapping
    @ResponseBody
    public String apiInfo() {
        return "This the apis for platform data.";
    }

    @RequestMapping(value={"/userinfo"}, method={RequestMethod.PUT})
    public void updateUserInfo(@RequestBody UserInfo userInfo, HttpServletRequest request, HttpServletResponse response) {
        UserInfo dbUserInfo = this.sysUserManager.getObjectById(userInfo.getUserCode());
        if (null == dbUserInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        String primaryUnit = dbUserInfo.getPrimaryUnit();
        dbUserInfo.copyNotNullProperty(userInfo);
        dbUserInfo.setPrimaryUnit(primaryUnit);
        this.sysUserManager.updateUserInfo(dbUserInfo);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/usersettings/{userCode}/{optID}"}, method={RequestMethod.GET})
    public void getUserAllSettings(@PathVariable String optID, @PathVariable String userCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.userSettingManager.getUserSettings(userCode, optID), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/usersetting/{userCode}/{paramCode}"}, method={RequestMethod.GET})
    public void getUserSetting(@PathVariable String userCode, @PathVariable String paramCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.userSettingManager.getUserSetting(userCode, paramCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allsetting"}, method={RequestMethod.GET})
    public void getUserSetting(HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.userSettingManager.getAllSettings(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/usersetting"}, method={RequestMethod.PUT})
    public void setUserSetting(@RequestBody String settingJson, HttpServletResponse response) {
        UserSetting us = (UserSetting)JSON.parseObject((String)settingJson, UserSetting.class);
        if (us != null) {
            this.platformEnvironment.saveUserSetting((IUserSetting)us);
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"put \u7684\u7528\u6237\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/usermenu/{optid}/{userCode}"}, method={RequestMethod.GET})
    public void listUserMenuOptInfos(@PathVariable String optid, @PathVariable String userCode, boolean asAdmin, HttpServletResponse response) {
        List menuFunsByUser = null;
        menuFunsByUser = StringUtils.isBlank((CharSequence)optid) || "null".equals(optid) ? this.platformEnvironment.listUserMenuOptInfos(userCode, asAdmin) : this.platformEnvironment.listUserMenuOptInfosUnderSuperOptId(userCode, optid, asAdmin);
        JsonResultUtils.writeSingleDataJson((Object)menuFunsByUser, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/checkpassword/{userCode}"}, method={RequestMethod.PUT})
    public void changeUserPassword(@PathVariable String userCode, @RequestBody String jsonData, HttpServletResponse response) {
        JSONObject json = (JSONObject)JSON.parse((String)jsonData);
        String password = StringBaseOpt.objectToString((Object)json.get((Object)"password"));
        JsonResultUtils.writeOriginalObject((Object)this.platformEnvironment.checkUserPassword(userCode, password), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/changepassword/{userCode}"}, method={RequestMethod.PUT})
    public void checkUserPassword(@PathVariable String userCode, @RequestBody String jsonData, HttpServletResponse response) {
        JSONObject json = (JSONObject)JSON.parse((String)jsonData);
        String newPassword = StringBaseOpt.objectToString((Object)json.get((Object)"newPassword"));
        this.platformEnvironment.changeUserPassword(userCode, newPassword);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/allusers/{appName}"}, method={RequestMethod.GET})
    public void listAllUsers(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllUsers(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allunits/{appName}"}, method={RequestMethod.GET})
    public void listAllUnits(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllUnits(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/alluserunits/{appName}"}, method={RequestMethod.GET})
    public void listAllUserUnits(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllUserUnits(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userunits/{appName}/{userCode}"}, method={RequestMethod.GET})
    public void listUserUnits(@PathVariable String appName, @PathVariable String userCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listUserUnits(userCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitusers/{appName}/{unitCode}"}, method={RequestMethod.GET})
    public void listUnitUsers(@PathVariable String appName, @PathVariable String unitCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listUnitUsers(unitCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitrepo/{appName}"}, method={RequestMethod.GET})
    public void getUnitRepo(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllUnits(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userrepo/{appName}"}, method={RequestMethod.GET})
    public void getUserRepo(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllUsers(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/rolerepo/{appName}"}, method={RequestMethod.GET})
    public void getRoleRepo(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllRoleInfo(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userroles/{userCode}"}, method={RequestMethod.GET})
    public void listUserRoles(@PathVariable String userCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listUserRoles(userCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/roleusers/{roleCode}"}, method={RequestMethod.GET})
    public void listRoleUsers(@PathVariable String roleCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listRoleUsers(roleCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userroleinfos/{userCode}"}, method={RequestMethod.GET})
    public void listUserRoleInfos(@PathVariable String userCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listUserRoles(userCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/roleuserinfos/{roleCode}"}, method={RequestMethod.GET})
    public void listRoleUserInfos(@PathVariable String roleCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listRoleUsers(roleCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitroles/{unitCode}"}, method={RequestMethod.GET})
    public void listUnitRoles(@PathVariable String unitCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listUnitRoles(unitCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/roleunits/{roleCode}"}, method={RequestMethod.GET})
    public void listRoleUnits(@PathVariable String roleCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listRoleUnits(roleCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/optinforepo/{appName}"}, method={RequestMethod.GET})
    public void getOptInfoRepo(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllOptInfo(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/catalogs/{appName}"}, method={RequestMethod.GET})
    public void listAllDataCatalogs(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listAllDataCatalogs(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/dictionary/{appName}/{catalogCode}"}, method={RequestMethod.GET})
    public void listDataDictionaries(@PathVariable String appName, @PathVariable String catalogCode, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.platformEnvironment.listDataDictionaries(catalogCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allrolepowers/{appName}"}, method={RequestMethod.GET})
    public void listAllRolePower(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.sysRoleManager.listAllRolePowers(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/alloptmethods/{appName}"}, method={RequestMethod.GET})
    public void listAllOptMethod(@PathVariable String appName, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.sysRoleManager.listAllOptMethods(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userdetails/{appName}/{queryParam}"}, method={RequestMethod.GET})
    public void loadUserDetails(@PathVariable String appName, @PathVariable String queryParam, String qtype, HttpServletResponse response) {
        if (qtype == null) {
            qtype = "loginName";
        }
        CentitUserDetails userDetails = null;
        switch (qtype) {
            case "loginName": {
                userDetails = this.platformEnvironment.loadUserDetailsByLoginName(queryParam);
                break;
            }
            case "userCode": {
                userDetails = this.platformEnvironment.loadUserDetailsByUserCode(queryParam);
                break;
            }
            case "regEmail": {
                userDetails = this.platformEnvironment.loadUserDetailsByRegEmail(queryParam);
                break;
            }
            case "regCellPhone": {
                userDetails = this.platformEnvironment.loadUserDetailsByRegCellPhone(queryParam);
                break;
            }
            default: {
                userDetails = this.platformEnvironment.loadUserDetailsByLoginName(queryParam);
            }
        }
        if (userDetails == null) {
            JsonResultUtils.writeErrorMessageJson((int)101, (String)("\u6ca1\u6709\u6307\u5b9a\u7684\u7528\u6237\uff1a" + qtype + "=" + queryParam), (HttpServletResponse)response);
            return;
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("userDetails", (Object)userDetails);
        resData.addResponseData("userUnits", (Object)userDetails.getUserUnits());
        resData.addResponseData("userPin", (Object)userDetails.getUserInfo().getUserPin());
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/ipenvironment/databaseinfo"}, method={RequestMethod.GET})
    public void listAllDatabase(HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(this.oatabaseInfoManager.listDatabase(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/ipenvironment/osinfo"}, method={RequestMethod.GET})
    public void listAllOS(HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.osInfoManager.listObjects(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/ipenvironment/userToken/{tokenId}"}, method={RequestMethod.GET})
    public void getUserToken(@PathVariable String tokenId, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.userAccessTokenManager.getObjectById((Serializable)((Object)tokenId)), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/ipenvironment/allUserToken"}, method={RequestMethod.GET})
    public void listAllUserToken(HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.userAccessTokenManager.listObjects(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/insertopt"}, method={RequestMethod.POST})
    public void insertOpt(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map param = (Map)JSON.parseObject((InputStream)request.getInputStream(), Map.class, (Feature[])new Feature[0]);
        List optInfos = JSON.parseArray((String)param.get("optInfos").toString(), OptInfo.class);
        List optMethods = JSON.parseArray((String)param.get("optMethods").toString(), OptMethod.class);
        this.platformEnvironment.insertOrUpdateMenu(optInfos, optMethods);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }
}

