/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.centit.framework.ip.service.UserDirectory;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.po.UserUnit;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="activeDirectoryUserDirectory")
public class ActiveDirectoryUserDirectoryImpl
implements UserDirectory {
    private static Logger logger = LoggerFactory.getLogger(ActiveDirectoryUserDirectoryImpl.class);
    @Resource
    @NotNull
    private UserUnitDao userUnitDao;
    @Resource
    @NotNull
    private UnitInfoDao unitInfoDao;
    @Resource
    @NotNull
    private UserRoleDao userRoleDao;
    @Resource(name="userInfoDao")
    @NotNull
    private UserInfoDao userInfoDao;
    @Value(value="${userdirectory.ldap.url:}")
    private String ldapUrl;
    @Value(value="${userdirectory.ldap.username:}")
    private String ldapUser;
    @Value(value="${userdirectory.ldap.userpassword:}")
    private String ldapUserPwd;
    @Value(value="${userdirectory.ldap.searchbase:}")
    private String searchBase;
    @Value(value="${userdirectory.default.rank:YG}")
    @NotNull
    private String defaultRank;
    @Value(value="${userdirectory.default.station:ZY}")
    @NotNull
    private String defaultStation;
    @Value(value="${userdirectory.default.rolecode:}")
    private String defaultUserRole;

    public String getDefaultUserRole() {
        return this.defaultUserRole;
    }

    public void setDefaultUserRole(String defaultUserRole) {
        this.defaultUserRole = defaultUserRole;
    }

    public String getDefaultRank() {
        return this.defaultRank;
    }

    public void setDefaultRank(String defaultRank) {
        this.defaultRank = defaultRank;
    }

    public String getDefaultStation() {
        return this.defaultStation;
    }

    public void setDefaultStation(String defaultStation) {
        this.defaultStation = defaultStation;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String getLdapUser() {
        return this.ldapUser;
    }

    public void setLdapUser(String ldapUser) {
        this.ldapUser = ldapUser;
    }

    public String getLdapUserPwd() {
        return this.ldapUserPwd;
    }

    public void setLdapUserPwd(String ldapUserPwd) {
        this.ldapUserPwd = ldapUserPwd;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public static String getAttributeString(Attribute attr) {
        if (attr == null) {
            return null;
        }
        try {
            return StringBaseOpt.objectToString((Object)attr.get());
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getAttributeString(Attributes attr, String attrName) {
        return ActiveDirectoryUserDirectoryImpl.getAttributeString(attr.get(attrName));
    }

    @Override
    @Transactional
    public int synchroniseUserDirectory() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.ldapUser);
        env.put("java.naming.security.credentials", this.ldapUserPwd);
        env.put("java.naming.provider.url", this.ldapUrl);
        Date now = DatetimeOpt.currentUtilDate();
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            HashMap<String, UnitInfo> allUnits = new HashMap<String, UnitInfo>();
            String searchFilter = "(objectCategory=group)";
            String[] returnedAtts = new String[]{"name", "description", "distinguishedName", "managedBy"};
            searchCtls.setReturningAttributes(returnedAtts);
            NamingEnumeration<SearchResult> answer = ctx.search(this.searchBase, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                boolean createNew;
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                String distinguishedName = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "distinguishedName");
                String unitName = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "description");
                if (unitName == null || distinguishedName == null) continue;
                UnitInfo unitInfo = this.unitInfoDao.getUnitByTag(distinguishedName);
                boolean bl = createNew = unitInfo == null;
                if (createNew) {
                    unitInfo = new UnitInfo();
                    unitInfo.setUnitCode(this.unitInfoDao.getNextKey());
                    unitInfo.setUnitTag(distinguishedName);
                    unitInfo.setIsValid("T");
                    unitInfo.setUnitType("L");
                    unitInfo.setUnitPath("/" + unitInfo.getUnitCode());
                    unitInfo.setCreateDate(now);
                }
                unitInfo.setUnitName(unitName);
                unitInfo.setUnitDesc(ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "managedBy"));
                unitInfo.setLastModifyDate(now);
                if (createNew) {
                    this.unitInfoDao.saveNewObject(unitInfo);
                } else {
                    this.unitInfoDao.updateUnit(unitInfo);
                }
                allUnits.put(distinguishedName, unitInfo);
            }
            searchFilter = "(&(objectCategory=person)(objectClass=user))";
            String[] userReturnedAtts = new String[]{"memberOf", "displayName", "sAMAccountName", "mail", "distinguishedName"};
            searchCtls.setReturningAttributes(userReturnedAtts);
            answer = ctx.search(this.searchBase, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                Attribute members;
                String userWord;
                String idCardNo;
                String regCellPhone;
                String regEmail;
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                String loginName = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "sAMAccountName");
                String userName = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "displayName");
                if (userName == null || loginName == null) continue;
                boolean createUser = false;
                UserInfo userInfo = this.userInfoDao.getUserByLoginName(loginName);
                if (userInfo == null) {
                    userInfo = new UserInfo();
                    userInfo.setUserCode(this.userInfoDao.getNextKey());
                    userInfo.setIsValid("T");
                    userInfo.setLoginName(loginName);
                    userInfo.setCreateDate(now);
                    createUser = true;
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{regEmail = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "mail")}) && regEmail.length() < 60 && this.userInfoDao.getUserByRegEmail(regEmail) == null) {
                    userInfo.setRegEmail(regEmail);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{regCellPhone = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "mobilePhone")}) && regCellPhone.length() < 15 && this.userInfoDao.getUserByRegCellPhone(regCellPhone) == null) {
                    userInfo.setRegCellPhone(regCellPhone);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{idCardNo = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "idCard")}) && idCardNo.length() < 20 && this.userInfoDao.getUserByIdCardNo(idCardNo) == null) {
                    userInfo.setIdCardNo(idCardNo);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userWord = ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "jobNo")}) && userWord.length() < 20 && this.userInfoDao.getUserByUserWord(userWord) == null) {
                    userInfo.setUserWord(userWord);
                }
                userInfo.setUserTag(ActiveDirectoryUserDirectoryImpl.getAttributeString(attrs, "distinguishedName"));
                userInfo.setUserName(userName);
                userInfo.setUpdateDate(now);
                if (createUser) {
                    this.userInfoDao.saveNewObject(userInfo);
                } else {
                    this.userInfoDao.updateUser(userInfo);
                }
                if (createUser && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.defaultUserRole})) {
                    UserRole role = new UserRole(new UserRoleId(userInfo.getUserCode(), this.defaultUserRole));
                    role.setObtainDate(now);
                    role.setCreateDate(now);
                    role.setChangeDesc("LDAP\u540c\u6b65\u65f6\u9ed8\u8ba4\u8bbe\u7f6e\u3002");
                    this.userRoleDao.mergeObject(role);
                }
                if ((members = attrs.get("memberOf")) == null) continue;
                NamingEnumeration<?> ms = members.getAll();
                while (ms.hasMoreElements()) {
                    List uus;
                    Object member = ms.next();
                    String groupName = StringBaseOpt.objectToString(member);
                    UnitInfo u = (UnitInfo)allUnits.get(groupName);
                    if (u == null || (uus = this.userUnitDao.listObjectByUserUnit(userInfo.getUserCode(), u.getUnitCode())) != null && uus.size() != 0) continue;
                    UserUnit uu = new UserUnit();
                    uu.setUserUnitId(this.userUnitDao.getNextKey());
                    uu.setUnitCode(u.getUnitCode());
                    uu.setUserCode(userInfo.getUserCode());
                    uu.setCreateDate(now);
                    uu.setIsPrimary("F");
                    uu.setUserRank(this.defaultRank);
                    uu.setUserStation(this.defaultStation);
                    this.userUnitDao.saveNewObject(uu);
                }
            }
            ctx.close();
            return 0;
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }
}

