/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.dao;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class DatabaseInfoDao
extends BaseDaoImpl<DatabaseInfo, String> {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("databaseName", "LIKE");
            this.filterField.put("databaseNames", "EQUAL");
            this.filterField.put("databaseType", "LIKE");
            this.filterField.put("hostPort", "LIKE");
            this.filterField.put("databaseUrl", "LIKE");
            this.filterField.put("username", "LIKE");
            this.filterField.put("password", "LIKE");
            this.filterField.put("dataDesc", "LIKE");
            this.filterField.put("createTime", "LIKE");
            this.filterField.put("created", "LIKE");
        }
        return this.filterField;
    }

    public boolean connectionTest(DatabaseInfo databaseInfo) {
        return DataSourceDescription.testConntect((DataSourceDescription)new DataSourceDescription(databaseInfo.getDatabaseUrl(), databaseInfo.getUsername(), databaseInfo.getPassword()));
    }

    public List<DatabaseInfo> listDatabase() {
        return this.listObjects();
    }

    public DatabaseInfo getDatabaseInfoById(String databaseCode) {
        DatabaseInfo dbi = (DatabaseInfo)this.getObjectById(databaseCode);
        return dbi;
    }

    public String getNextKey() {
        return StringBaseOpt.fillZeroForString((String)String.valueOf(DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_DATABASECODE")), (int)10);
    }

    public JSONArray queryDatabaseAsJson(String databaseName, PageDesc pageDesc) {
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            return super.listObjectsAsJson(new HashMap(1), pageDesc);
        }
        String matchStr = QueryUtils.getMatchString((String)databaseName);
        return super.listObjectsByFilterAsJson("where DATABASE_NAME like ? or DATABASE_URL like ?", new Object[]{matchStr, matchStr}, pageDesc);
    }
}

