/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.service.DatabaseInfoManager;
import com.centit.framework.ip.service.OsInfoManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/sys/os"})
public class OsInfoController
extends BaseController {
    @Resource
    private OsInfoManager osInfoMag;
    @Resource
    private DatabaseInfoManager databaseInfoMag;
    private String optId = "OS";

    @RequestMapping(method={RequestMethod.GET})
    public void list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = OsInfoController.convertSearchColumn((HttpServletRequest)request);
        JSONArray listObjects = this.osInfoMag.listOsInfoAsJson(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void saveOsInfo(@Valid OsInfo osinfo, HttpServletRequest request, HttpServletResponse response) {
        if (osinfo == null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (HttpServletResponse)response);
            return;
        }
        osinfo.setCreated(super.getLoginUserCode(request));
        osinfo.setCreateTime(new Date());
        this.osInfoMag.saveNewObject(osinfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)osinfo.getOsId(), (String)"create", (String)"\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf", (Object)osinfo);
    }

    @RequestMapping(value={"/{osId}"}, method={RequestMethod.PUT})
    public void updateOsInfo(@PathVariable String osId, @Valid OsInfo osinfo, HttpServletRequest request, HttpServletResponse response) {
        OsInfo dbOsInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        OsInfo oldValue = new OsInfo();
        BeanUtils.copyProperties((Object)dbOsInfo, (Object)oldValue);
        this.osInfoMag.mergeObject(osinfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)osId, (String)"update", (String)"\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", (Object)osinfo, (Object)oldValue);
    }

    @RequestMapping(value={"/{osId}"}, method={RequestMethod.GET})
    public void getOsInhfo(@PathVariable String osId, HttpServletResponse response) {
        OsInfo osInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        JsonResultUtils.writeSingleDataJson((Object)osInfo, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(OsInfo.class, (String[])new String[]{"osInfo"}));
    }

    @RequestMapping(value={"/{osId}"}, method={RequestMethod.DELETE})
    public void deleteOsInfo(@PathVariable String osId, HttpServletRequest request, HttpServletResponse response) {
        OsInfo dbOsInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        if (this.databaseInfoMag.listDatabaseByOsId(osId).size() > 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u4e1a\u52a1\u7cfb\u7edf\u88ab\u96c6\u6210\u6570\u636e\u5e93\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664\uff01", (HttpServletResponse)response);
            return;
        }
        this.osInfoMag.deleteObjectById((Serializable)((Object)osId));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)osId, (String)"delete", (String)"\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf", (Object)dbOsInfo);
    }
}

