/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.DatabaseInfoManager;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/sys/database"})
public class DatabaseInfoController
extends BaseController {
    @Resource
    private DatabaseInfoManager databaseInfoMag;
    private String optId = "DATABASE";

    @RequestMapping(method={RequestMethod.GET})
    public void list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.convertSearchColumn((HttpServletRequest)request);
        JSONArray listObjects = this.databaseInfoMag.listObjectsAsJson(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void saveDatabaseInfo(@Valid DatabaseInfo databaseinfo, HttpServletRequest request, HttpServletResponse response) {
        DatabaseInfo temp = (DatabaseInfo)this.databaseInfoMag.getObjectById((Serializable)((Object)this.databaseInfoMag.getNextKey()));
        if (temp != null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u6570\u636e\u5e93\u6807\u8bc6\u5df2\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        databaseinfo.setClearPassword(databaseinfo.getPassword());
        databaseinfo.setCreated(super.getLoginUserCode(request));
        this.databaseInfoMag.saveNewObject(databaseinfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)databaseinfo.getDatabaseCode(), (String)"create", (String)"\u65b0\u589e\u6570\u636e\u5e93", (Object)databaseinfo);
    }

    @RequestMapping(value={"testConnect"}, method={RequestMethod.GET})
    public void testConnect(@Valid DatabaseInfo databaseInfo, HttpServletResponse response) {
        boolean result = DataSourceDescription.testConntect((DataSourceDescription)new DataSourceDescription(databaseInfo.getDatabaseUrl(), databaseInfo.getUsername(), databaseInfo.getPassword()));
        if (result) {
            JsonResultUtils.writeSingleDataJson((Object)"\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f", (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.PUT})
    public void updateDatabaseInfo(@PathVariable String databaseCode, @Valid DatabaseInfo databaseinfo, HttpServletRequest request, HttpServletResponse response) {
        DatabaseInfo temp = (DatabaseInfo)this.databaseInfoMag.getObjectById((Serializable)((Object)databaseCode));
        if (!databaseinfo.getPassword().equals(temp.getPassword())) {
            databaseinfo.setClearPassword(databaseinfo.getPassword());
        }
        DatabaseInfo oldValue = new DatabaseInfo();
        BeanUtils.copyProperties((Object)temp, (Object)oldValue);
        this.databaseInfoMag.mergeObject(databaseinfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)databaseCode, (String)"update", (String)"\u66f4\u65b0\u6570\u636e\u5e93\u4fe1\u606f", (Object)databaseinfo, (Object)oldValue);
    }

    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.GET})
    public void getDatabaseInhfo(@PathVariable String databaseCode, HttpServletResponse response) {
        DatabaseInfo databaseInfo = (DatabaseInfo)this.databaseInfoMag.getObjectById((Serializable)((Object)databaseCode));
        JsonResultUtils.writeSingleDataJson((Object)databaseInfo, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(DatabaseInfo.class, (String[])new String[]{"databaseInfo"}));
    }

    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.DELETE})
    public void deleteDatabase(@PathVariable String databaseCode, HttpServletRequest request, HttpServletResponse response) {
        DatabaseInfo databaseInfo = (DatabaseInfo)this.databaseInfoMag.getObjectById((Serializable)((Object)databaseCode));
        this.databaseInfoMag.deleteObjectById((Serializable)((Object)databaseCode));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)databaseCode, (String)"delete", (String)"\u5220\u9664\u6570\u636e\u5e93", (Object)databaseInfo);
    }
}

