/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmpp;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.xmpp.ChannelPacketListener;
import org.codehaus.xfire.xmpp.SoapEnvelopePacket;
import org.codehaus.xfire.xmpp.XMPPTransport;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;

public class XMPPChannel
extends AbstractChannel {
    private XMPPConnection conn;

    public XMPPChannel(String uri, XMPPTransport transport) {
        this.setUri(uri);
        this.setTransport(transport);
    }

    public void open() throws XFireException {
        if (this.conn != null) {
            return;
        }
        XMPPTransport transport = (XMPPTransport)this.getTransport();
        try {
            this.conn = new XMPPConnection(transport.getServer());
            this.conn.login(transport.getUsername(), transport.getPassword(), this.getUri());
            this.conn.addPacketListener((PacketListener)new ChannelPacketListener(transport.getXFire(), this), (PacketFilter)new ToContainsFilter(transport.getUsername()));
        }
        catch (XMPPException e) {
            throw new XFireException("Couldn't open channel.", (Throwable)e);
        }
    }

    public void send(MessageContext context, OutMessage message) throws XFireFault {
        XMPPTransport transport = (XMPPTransport)this.getTransport();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            context.setProperty((Object)"xfire.serializeProlog", (Object)Boolean.FALSE);
            XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding());
            message.getSerializer().writeMessage(message, writer, context);
            writer.flush();
            writer.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't write stream.", (Throwable)e);
        }
        SoapEnvelopePacket response = new SoapEnvelopePacket(out.toString());
        response.setFrom(this.conn.getUser());
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            SoapEnvelopePacket req = (SoapEnvelopePacket)((Object)context.getProperty((Object)"xmpp.packet"));
            response.setTo(req.getFrom());
            response.setType(IQ.Type.RESULT);
            response.setPacketID(req.getPacketID());
        } else {
            response.setTo(message.getUri());
        }
        XMPPError error = (XMPPError)context.getProperty((Object)"xfire.xmppError");
        if (error != null) {
            response.setError(error);
        }
        this.conn.sendPacket((Packet)response);
    }

    public void close() {
        this.conn.close();
    }

    protected Document readDocument(String text) {
        try {
            SAXReader reader = new SAXReader();
            return reader.read((Reader)new StringReader(text));
        }
        catch (DocumentException e) {
            throw new XFireRuntimeException("Couldn't read response document: " + text, (Throwable)e);
        }
    }
}

