/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.jpa;

import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.persistence.Embeddable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.DescribedAs;
import org.hamcrest.core.IsEqual;
import org.testinfected.hamcrest.jpa.IsComponentEqual;
import org.testinfected.hamcrest.jpa.PersistentFieldPredicate;
import org.testinfected.hamcrest.jpa.Reflection;

public class SamePersistentFieldsAs<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final T expectedEntity;

    public SamePersistentFieldsAs(T expectedEntity) {
        this.expectedEntity = expectedEntity;
    }

    protected boolean matchesSafely(T argument, Description mismatchDescription) {
        return this.isCompatibleType(argument, mismatchDescription) && this.hasMatchingPersistentFields(argument, mismatchDescription);
    }

    private boolean isCompatibleType(T argument, Description mismatchDescription) {
        if (!this.expectedEntity.getClass().isInstance(argument)) {
            mismatchDescription.appendText("is incompatible type: " + argument.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    private boolean hasMatchingPersistentFields(T argument, Description mismatchDescription) {
        for (Matcher<T> matcher : SamePersistentFieldsAs.persistentFieldsMatchersFor(this.expectedEntity)) {
            if (matcher.matches(argument)) continue;
            matcher.describeMismatch(argument, mismatchDescription);
            return false;
        }
        return true;
    }

    private static <T> Iterable<Matcher<? extends T>> persistentFieldsMatchersFor(T entity) {
        ArrayList<Matcher<T>> matchers = new ArrayList<Matcher<T>>();
        for (Field field : PersistentFieldPredicate.persistentFieldsOf(entity)) {
            matchers.add((Matcher<T>)new FieldMatcher(field, SamePersistentFieldsAs.valueMatcherFor(entity, field)));
        }
        return matchers;
    }

    private static Matcher<?> valueMatcherFor(Object entity, Field field) {
        if (SamePersistentFieldsAs.isEmbedded(field)) {
            return IsComponentEqual.componentEqualTo(Reflection.readField(entity, field));
        }
        if (SamePersistentFieldsAs.isAssociation(field)) {
            return SamePersistentFieldsAs.anyAssociation();
        }
        return SamePersistentFieldsAs.equalTo(Reflection.readField(entity, field));
    }

    private static Matcher<?> anyAssociation() {
        return DescribedAs.describedAs((String)"an association", (Matcher)Matchers.anything(), (Object[])new Object[0]);
    }

    private static <T> IsEqual<T> equalTo(T arg) {
        return new IsEqual(arg);
    }

    private static boolean isAssociation(Field field) {
        return SamePersistentFieldsAs.isManyToOne(field) || SamePersistentFieldsAs.isOneToMany(field) || SamePersistentFieldsAs.isManyToMany(field);
    }

    private static boolean isManyToMany(Field field) {
        return field.getAnnotation(ManyToMany.class) != null;
    }

    private static boolean isOneToMany(Field field) {
        return field.getAnnotation(OneToMany.class) != null;
    }

    private static boolean isManyToOne(Field field) {
        return field.getAnnotation(ManyToOne.class) != null;
    }

    private static boolean isEmbedded(Field field) {
        return SamePersistentFieldsAs.isEmbeddable(field.getType());
    }

    private static boolean isEmbeddable(Class<?> type) {
        return type.getAnnotation(Embeddable.class) != null;
    }

    public void describeTo(Description description) {
        description.appendText("with fields [");
        boolean addSeparator = false;
        for (Field field : PersistentFieldPredicate.persistentFieldsOf(this.expectedEntity)) {
            if (addSeparator) {
                description.appendText(", ");
            }
            description.appendText(field.getName() + ": ");
            SamePersistentFieldsAs.valueMatcherFor(this.expectedEntity, field).describeTo(description);
            addSeparator = true;
        }
        description.appendText("]");
    }

    @Factory
    public static <T> Matcher<T> samePersistentFieldsAs(T entity) {
        return new SamePersistentFieldsAs<T>(entity);
    }

    public static class FieldMatcher<T>
    extends TypeSafeDiagnosingMatcher<T> {
        private final Field field;
        private final Matcher<?> valueMatcher;

        public FieldMatcher(Field field, Matcher<?> valueMatcher) {
            this.field = field;
            this.valueMatcher = valueMatcher;
        }

        protected boolean matchesSafely(T argument, Description mismatchDescription) {
            Object actualValue = Reflection.readField(argument, this.field);
            boolean valueMatches = this.valueMatcher.matches(actualValue);
            if (!valueMatches) {
                mismatchDescription.appendText(this.field.getName() + " ");
                this.valueMatcher.describeMismatch(actualValue, mismatchDescription);
            }
            return valueMatches;
        }

        public void describeTo(Description description) {
            description.appendText(this.field.getName() + ": ").appendDescriptionOf(this.valueMatcher);
        }
    }
}

