/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.ws;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.WsResponseExt;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.TioSiteImServerAioListener;
import org.tio.sitexxx.im.server.ws.ImWsMsgHandler;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsSessionContext;
import org.tio.websocket.server.WsServerAioListener;

public class ImWsServerAioListener
extends WsServerAioListener {
    private static Logger log = LoggerFactory.getLogger(ImWsServerAioListener.class);
    public static final ImWsServerAioListener me = new ImWsServerAioListener();

    public static void main(String[] args) {
    }

    private ImWsServerAioListener() {
    }

    public void onAfterConnected(ChannelContext channelContext, boolean isConnected, boolean isReconnect) throws Exception {
        super.onAfterConnected(channelContext, isConnected, isReconnect);
        WsSessionContext wsSessionContext = (WsSessionContext)channelContext.get();
        TioSiteImServerAioListener.me.onAfterConnected(channelContext, isConnected, isReconnect);
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        imSessionContext.setWebsocket(true);
        imSessionContext.setWsSessionContext(wsSessionContext);
    }

    public void onAfterDecoded(ChannelContext channelContext, Packet packet, int packetSize) throws Exception {
        super.onAfterDecoded(channelContext, packet, packetSize);
        WsRequest wsRequest = (WsRequest)packet;
        Opcode opcode = wsRequest.getWsOpcode();
        if (opcode == Opcode.PONG) {
            return;
        }
        ImPacket imPacket = ImWsMsgHandler.toImPacket(wsRequest, channelContext);
        if (imPacket != null) {
            TioSiteImServerAioListener.me.onAfterDecoded(channelContext, (Packet)imPacket, packetSize);
        }
    }

    public void onAfterSent(ChannelContext channelContext, Packet packet, boolean isSentSuccess) throws Exception {
        super.onAfterSent(channelContext, packet, isSentSuccess);
        if (packet instanceof WsResponseExt) {
            WsResponseExt wsResponse = (WsResponseExt)packet;
            ImPacket imPacket = wsResponse.getInitPacket();
            TioSiteImServerAioListener.me.onAfterSent(channelContext, (Packet)imPacket, isSentSuccess);
        } else {
            log.debug("\u63e1\u624b\u5305");
        }
    }

    public void onBeforeClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) throws Exception {
        super.onBeforeClose(channelContext, throwable, remark, isRemove);
        TioSiteImServerAioListener.me.onBeforeClose(channelContext, throwable, remark, isRemove);
    }
}

