/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.call;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall05OfferSdpReq;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall06OfferSdpNtf;
import org.tio.sitexxx.im.common.bs.wx.webrtc.base.WxCallBase;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.call.WxCall07AnswerSdpReqHandler;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.service.model.main.WxCallItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.wx.WxCallItemService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxCall05OfferSdpReq)
public class WxCall05OfferSdpReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxCall05OfferSdpReqHandler.class);
    public static final WxCall05OfferSdpReqHandler me = new WxCall05OfferSdpReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxCall05OfferSdpReq req = (WxCall05OfferSdpReq)Json.toBean((String)packet.getBodyStr(), WxCall05OfferSdpReq.class);
        WxCallItem wxCallItem = WxCallItemService.me.getById(req.getId());
        String summary = Command.WxCall05OfferSdpReq.name();
        WxCallUtils.saveCallLog(packet, channelContext, isWebsocket, curr, (WxCallBase)req, summary);
        WxCall06OfferSdpNtf ntf = new WxCall06OfferSdpNtf();
        ntf.fill(wxCallItem);
        ntf.setSdp(req.getSdp());
        ImPacket toPacket = new ImPacket(Command.WxCall06OfferSdpNtf, (Object)ntf);
        Tio.sendToId((TioConfig)channelContext.tioConfig, (String)ntf.getTocid(), (Packet)toPacket);
        if (Objects.equals(wxCallItem.getFromcid(), wxCallItem.getTocid())) {
            WxCall07AnswerSdpReqHandler.updateStatusWhenStreamFinished(wxCallItem);
        }
    }
}

