/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jspecify.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.MimeType;

public abstract class KotlinSerializationSupport<T extends SerialFormat> {
    private final Map<Type, KSerializer<Object>> typeSerializerCache = new ConcurrentReferenceHashMap();
    private final Map<KType, KSerializer<Object>> kTypeSerializerCache = new ConcurrentReferenceHashMap();
    private final T format;
    private final List<MimeType> supportedMimeTypes;
    private final Predicate<ResolvableType> typePredicate;

    protected KotlinSerializationSupport(T format, MimeType ... supportedMimeTypes) {
        this.format = format;
        this.typePredicate = KotlinDetector::hasSerializableAnnotation;
        this.supportedMimeTypes = Arrays.asList(supportedMimeTypes);
    }

    protected KotlinSerializationSupport(T format, Predicate<ResolvableType> typePredicate, MimeType ... supportedMimeTypes) {
        this.format = format;
        this.typePredicate = typePredicate;
        this.supportedMimeTypes = Arrays.asList(supportedMimeTypes);
    }

    protected final T format() {
        return this.format;
    }

    protected final List<MimeType> supportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    protected final boolean canSerialize(ResolvableType type, @Nullable MimeType mimeType) {
        if (!this.typePredicate.test(type) || ResolvableType.NONE.equals((Object)type)) {
            return false;
        }
        return this.serializer(type) != null && this.supports(mimeType);
    }

    private boolean supports(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType candidate : this.supportedMimeTypes) {
            if (!candidate.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    protected final @Nullable KSerializer<Object> serializer(ResolvableType resolvableType) {
        Type type;
        KSerializer serializer;
        Object object = resolvableType.getSource();
        if (object instanceof MethodParameter) {
            KFunction function;
            MethodParameter parameter = (MethodParameter)object;
            Method method = parameter.getMethod();
            Assert.notNull((Object)method, (String)"Method must not be null");
            if (KotlinDetector.isKotlinType(method.getDeclaringClass()) && (function = ReflectJvmMapping.getKotlinFunction((Method)method)) != null) {
                KType type2 = parameter.getParameterIndex() == -1 ? function.getReturnType() : ((KParameter)KCallables.getValueParameters((KCallable)function).get(parameter.getParameterIndex())).getType();
                KSerializer serializer2 = this.kTypeSerializerCache.get(type2);
                if (serializer2 == null) {
                    try {
                        serializer2 = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (KType)type2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (serializer2 != null) {
                        this.kTypeSerializerCache.put(type2, (KSerializer<Object>)serializer2);
                    }
                }
                return serializer2;
            }
        }
        if ((serializer = this.typeSerializerCache.get(type = resolvableType.getType())) == null) {
            try {
                serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (Type)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (serializer != null) {
                this.typeSerializerCache.put(type, (KSerializer<Object>)serializer);
            }
        }
        return serializer;
    }
}

