/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.util.Set;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.boot.logging.structured.StructuredLoggingJsonProperties;
import org.springframework.core.env.Environment;

class StructuredLoggingJsonPropertiesBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final String ENVIRONMENT_BEAN_NAME = "environment";

    StructuredLoggingJsonPropertiesBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Environment environment = (Environment)beanFactory.getBean(ENVIRONMENT_BEAN_NAME, Environment.class);
        StructuredLoggingJsonProperties properties = StructuredLoggingJsonProperties.get(environment);
        if (properties != null) {
            Set<Class<StructuredLoggingJsonMembersCustomizer<?>>> customizers = properties.customizer();
            String stackTracePrinter = StructuredLoggingJsonPropertiesBeanFactoryInitializationAotProcessor.getCustomStackTracePrinter(properties);
            if (stackTracePrinter != null || !customizers.isEmpty()) {
                return new AotContribution(beanFactory.getBeanClassLoader(), customizers, stackTracePrinter);
            }
        }
        return null;
    }

    private static String getCustomStackTracePrinter(StructuredLoggingJsonProperties properties) {
        StructuredLoggingJsonProperties.StackTrace stackTrace = properties.stackTrace();
        return stackTrace != null && stackTrace.hasCustomPrinter() ? stackTrace.printer() : null;
    }

    private static final class AotContribution
    implements BeanFactoryInitializationAotContribution {
        private final ClassLoader classLoader;
        private final Set<Class<? extends StructuredLoggingJsonMembersCustomizer<?>>> customizers;
        private final String stackTracePrinter;

        private AotContribution(ClassLoader classLoader, Set<Class<? extends StructuredLoggingJsonMembersCustomizer<?>>> customizers, String stackTracePrinter) {
            this.classLoader = classLoader;
            this.customizers = customizers;
            this.stackTracePrinter = stackTracePrinter;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
            this.customizers.forEach(customizer -> reflection.registerType(customizer, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}));
            if (this.stackTracePrinter != null) {
                reflection.registerTypeIfPresent(this.classLoader, this.stackTracePrinter, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
            }
        }
    }
}

