/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.bulkload.BulkloadOperation;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.jdbc.BulkloadResultHandler;
import org.postgresql.util.PSQLException;

public abstract class BulkloadOperationImpl
implements BulkloadOperation {
    QueryExecutorImpl queryExecutor;
    int rowFormat;
    int[] fieldFormats;
    long handledRowCount = -1L;
    BulkloadResultHandler bulkloadHandler;

    void init(BulkloadResultHandler handler, QueryExecutorImpl q, int fmt, int[] fmts) {
        this.bulkloadHandler = handler;
        this.queryExecutor = q;
        this.rowFormat = fmt;
        this.fieldFormats = fmts;
    }

    @Override
    public void cancelBulkload() throws SQLException {
        this.queryExecutor.cancelBulkload(this);
    }

    @Override
    public int getFieldCount() {
        return this.fieldFormats.length;
    }

    @Override
    public int getFieldFormat(int field) {
        return this.fieldFormats[field];
    }

    @Override
    public int getFormat() {
        return this.rowFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            return this.queryExecutor.hasLock(this);
        }
    }

    public void handleCommandStatus(String status) throws PSQLException {
    }

    public long getHandledRowCount() {
        return this.handledRowCount;
    }

    @Override
    public ResultSet getHandledResultSet() {
        return this.bulkloadHandler.getResults().getResultSet();
    }
}

