/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine.render;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Img;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.layout.engine.render.Processor;
import org.ofdrw.layout.engine.render.RenderException;

public class ImgRender
implements Processor {
    @Override
    public void render(ST_Loc pageLoc, CT_PageBlock layer, ResManager resManager, Div e, AtomicInteger maxUnitID) throws RenderException {
        if (e instanceof Img) {
            ImgRender.render(layer, resManager, (Img)e, maxUnitID);
        }
    }

    public static void render(CT_PageBlock layer, ResManager resManager, Img e, AtomicInteger maxUnitID) {
        if (e == null) {
            return;
        }
        Path p = e.getSrc();
        if (p == null || Files.notExists(p, new LinkOption[0])) {
            throw new IllegalArgumentException("\u56fe\u7247\u5bf9\u8c61(Img)\u8def\u5f84\u975e\u6cd5");
        }
        ST_ID id = null;
        try {
            id = resManager.addImage(p);
        }
        catch (IOException ex) {
            throw new RenderException("\u6e32\u67d3\u56fe\u7247\u590d\u5236\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
        ImageObject imgObj = new ImageObject((long)maxUnitID.incrementAndGet());
        imgObj.setResourceID(id.ref());
        double x = e.getX() + e.getMarginLeft() + e.getBorderLeft() + e.getPaddingLeft();
        double y = e.getY() + e.getMarginTop() + e.getBorderTop() + e.getPaddingTop();
        imgObj.setBoundary(x, y, e.getWidth().doubleValue(), e.getHeight().doubleValue());
        imgObj.setCTM(new ST_Array(e.getWidth().doubleValue(), 0.0, 0.0, e.getHeight().doubleValue(), 0.0, 0.0));
        if (e.getOpacity() != null) {
            imgObj.setAlpha(Integer.valueOf((int)(e.getOpacity() * 255.0)));
        }
        layer.addPageBlock((PageBlockType)imgObj);
    }
}

