/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.io.IOException;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.text.text.Weight;
import org.ofdrw.font.Font;
import org.ofdrw.layout.element.canvas.CanvasBase;
import org.ofdrw.layout.element.canvas.DrawContext;
import org.ofdrw.layout.element.canvas.FontSetting;
import org.ofdrw.layout.element.canvas.TextAlign;

public class ArtWord
extends CanvasBase {
    private Font font;
    private Double fontSize = 3.0;
    private Double letterSpacing = 0.0;
    private boolean bold = false;
    private Weight weight = null;
    private boolean italic = false;
    private boolean underline = false;
    private double underlineOffset = 1.2;
    private double underlineWidth = 0.0;
    private String text;
    private int[] color = new int[]{0, 0, 0};
    private TextAlign textAlign;
    private org.ofdrw.layout.element.TextAlign textLayoutAlign;
    private double horizontalScaling = 1.0;
    private double verticalScaling = 1.0;
    private double horizontalInclination = 0.0;
    private double verticalInclination = 0.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    public ArtWord(Double width, Double height) {
        super(width, height);
    }

    public int[] getColor() {
        return this.color;
    }

    public ArtWord setColor(int[] rgb) {
        this.color = rgb;
        return this;
    }

    public ArtWord setColor(int r, int g, int b) {
        this.color = new int[]{r, g, b};
        return this;
    }

    public ArtWord setColor(String color) {
        this.color = new int[]{Integer.parseInt(color.substring(1, 3), 16), Integer.parseInt(color.substring(3, 5), 16), Integer.parseInt(color.substring(5, 7), 16)};
        return this;
    }

    public int length() {
        return this.text.length();
    }

    public Font getFont() {
        return this.font;
    }

    public ArtWord setFont(Font font) {
        this.font = font;
        return this;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public ArtWord setFontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public Double getLetterSpacing() {
        return this.letterSpacing;
    }

    public ArtWord setLetterSpacing(Double letterSpacing) {
        this.letterSpacing = letterSpacing;
        return this;
    }

    public boolean isBold() {
        return this.bold;
    }

    public ArtWord setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public Weight getWeight() {
        return this.weight;
    }

    public ArtWord setWeight(Weight weight) {
        this.weight = weight;
        return this;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public ArtWord setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public ArtWord setUnderline(boolean underline) {
        this.underline = underline;
        return this;
    }

    public ArtWord setUnderline(boolean underline, double offset, double width) {
        this.underline = underline;
        this.underlineOffset = offset;
        this.underlineWidth = width;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public ArtWord setText(String text) {
        this.text = text;
        return this;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getVerticalInclination() {
        return this.verticalInclination;
    }

    public void setVerticalInclination(double verticalInclination) {
        this.verticalInclination = verticalInclination;
    }

    public double getHorizontalInclination() {
        return this.horizontalInclination;
    }

    public void setHorizontalInclination(double horizontalInclination) {
        this.horizontalInclination = horizontalInclination;
    }

    public double getVerticalScaling() {
        return this.verticalScaling;
    }

    public void setVerticalScaling(double verticalScaling) {
        this.verticalScaling = verticalScaling;
    }

    public double getHorizontalScaling() {
        return this.horizontalScaling;
    }

    public void setHorizontalScaling(double horizontalScaling) {
        this.horizontalScaling = horizontalScaling;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public double getUnderlineOffset() {
        return this.underlineOffset;
    }

    public double getUnderlineWidth() {
        return this.underlineWidth;
    }

    public org.ofdrw.layout.element.TextAlign getTextLayoutAlign() {
        return this.textLayoutAlign;
    }

    public void setTextLayoutAlign(org.ofdrw.layout.element.TextAlign textLayoutAlign) {
        this.textLayoutAlign = textLayoutAlign;
    }

    @Override
    public ArtWord clone() {
        ArtWord artWord = new ArtWord(this.getWidth(), this.getHeight());
        artWord.font = this.font;
        artWord.fontSize = this.fontSize;
        artWord.letterSpacing = this.letterSpacing;
        artWord.bold = this.bold;
        artWord.weight = this.weight;
        artWord.italic = this.italic;
        artWord.underline = this.underline;
        artWord.underlineOffset = this.underlineOffset;
        artWord.underlineWidth = this.underlineWidth;
        artWord.text = this.text;
        artWord.color = this.color == null ? null : (int[])this.color.clone();
        return artWord;
    }

    @Override
    public void draw(DrawContext ctx) throws IOException {
        FontSetting fontSetting = new FontSetting(this.fontSize, this.font);
        fontSetting.setLetterSpacing(this.letterSpacing);
        if (this.bold) {
            fontSetting.setBold();
        }
        if (this.weight != null) {
            fontSetting.setFontWeight(this.weight.getWeight());
        }
        fontSetting.setItalic(this.italic);
        fontSetting.setTextAlign(this.textAlign);
        ctx.setFont(fontSetting);
        ctx.setFillColor(this.color);
        ctx.setTransform(this.horizontalScaling, this.verticalInclination, this.horizontalInclination, this.verticalScaling, this.offsetX, this.offsetY);
        double textWidth = ctx.measureText((String)this.text).width;
        double x = 0.0;
        if (this.textLayoutAlign != null) {
            switch (this.textLayoutAlign) {
                case left: {
                    x = 0.0;
                    break;
                }
                case right: {
                    x = this.getWidth() - textWidth;
                    break;
                }
                case center: {
                    x = (this.getWidth() - textWidth) / 2.0;
                    break;
                }
                default: {
                    x = 0.0;
                }
            }
        }
        ctx.fillText(this.text, x, this.fontSize);
        if (this.underline) {
            ctx.setLineWidth(this.underlineWidth == 0.0 ? this.fontSize * 0.05 : this.underlineWidth);
            ctx.beginPath();
            ctx.setGlobalAlpha(1.0);
            ctx.strokeStyle = CT_Color.rgb((int[])this.color);
            ctx.moveTo(x, this.fontSize + this.offsetY + this.underlineOffset);
            ctx.lineTo(x + textWidth, this.fontSize + this.offsetY + this.underlineOffset);
            ctx.stroke();
        }
    }
}

