/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.sm2strut.builder;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.jetbrains.annotations.NotNull;
import org.ofdrw.gm.cert.CertTools;
import org.ofdrw.gm.sm2strut.ContentInfo;
import org.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import org.ofdrw.gm.sm2strut.OIDs;
import org.ofdrw.gm.sm2strut.SignedData;
import org.ofdrw.gm.sm2strut.SignerInfo;
import org.ofdrw.gm.sm2strut.builder.CertSigHolder;

public final class SignedDataBuilder {
    public static SignedData signedData(@NotNull byte[] plaintext, @NotNull byte[] signature, @NotNull java.security.cert.Certificate certificate) throws GeneralSecurityException, IOException {
        if (plaintext == null || plaintext.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u539f\u6587(plaintext)\u4e3a\u7a7a");
        }
        if (signature == null || signature.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u503c(signature)\u4e3a\u7a7a");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("\u8bc1\u4e66(certificate)\u4e3a\u7a7a");
        }
        ArrayList<CertSigHolder> certSigArr = new ArrayList<CertSigHolder>(1);
        certSigArr.add(new CertSigHolder(signature, certificate));
        return SignedDataBuilder.signedData(plaintext, certSigArr, null);
    }

    public static SignedData signedData(@NotNull byte[] plaintext, @NotNull List<CertSigHolder> certSigArr, List<java.security.cert.Certificate> extCertArr) throws GeneralSecurityException, IOException {
        if (plaintext == null || plaintext.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u539f\u6587(plaintext)\u4e3a\u7a7a");
        }
        if (certSigArr == null || certSigArr.isEmpty()) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u3001\u7b7e\u540d\u503c\u5217\u8868(signature)\u4e3a\u7a7a");
        }
        DERSet digestAlgorithms = new DERSet((ASN1Encodable)OIDs.sm3);
        ContentInfo contentInfo = new ContentInfo(OIDs.data, (ASN1Encodable)new DEROctetString(plaintext));
        int len = certSigArr.size();
        int i = 0;
        if (extCertArr != null) {
            len += extCertArr.size();
        }
        ASN1Encodable[] certArr = new ASN1Encodable[len];
        for (CertSigHolder holder : certSigArr) {
            certArr[i] = holder.getAsn1Cert();
            ++i;
        }
        if (extCertArr != null && !extCertArr.isEmpty()) {
            for (java.security.cert.Certificate c : extCertArr) {
                certArr[i] = CertTools.asn1(c);
                ++i;
            }
        }
        DERSet certificates = new DERSet(certArr);
        ASN1Encodable[] signers = new ASN1Encodable[certSigArr.size()];
        for (int j = 0; j < certSigArr.size(); ++j) {
            CertSigHolder item = certSigArr.get(j);
            signers[j] = SignedDataBuilder.sm2Signer(item.signature, item.getAsn1Cert());
        }
        DERSet signerInfos = new DERSet(signers);
        return new SignedData((ASN1Set)digestAlgorithms, contentInfo, (ASN1Set)certificates, (ASN1Set)signerInfos);
    }

    public static SignerInfo sm2Signer(byte[] signature, Certificate certificate) {
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(certificate.getIssuer(), certificate.getSerialNumber());
        return new SignerInfo(issuerAndSerialNumber, new AlgorithmIdentifier(OIDs.sm3), new AlgorithmIdentifier(OIDs.sm2), (ASN1OctetString)new DEROctetString(signature));
    }
}

