/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.font;

import org.ofdrw.font.Font;

public enum FontName {
    SimSun,
    SimHei,
    MSYahei,
    KaiTi,
    FangSong,
    TimesNewRoman;

    public static final double[] NOTO_PRINTABLE_ASCII_WIDTH_MAP;
    public static final double[] TIMES_NEW_ROMAN_PRINTABLE_ASCII_MAP;

    public Font font() {
        switch (this) {
            case SimHei: {
                return new Font("\u9ed1\u4f53", "\u9ed1\u4f53");
            }
            case KaiTi: {
                return new Font("\u6977\u4f53", "\u6977\u4f53");
            }
            case MSYahei: {
                return new Font("\u5fae\u8f6f\u96c5\u9ed1", "\u5fae\u8f6f\u96c5\u9ed1");
            }
            case FangSong: {
                return new Font("\u4eff\u5b8b", "\u4eff\u5b8b");
            }
            case TimesNewRoman: {
                return new Font("Times New Roman", "Times New Roman", null, TIMES_NEW_ROMAN_PRINTABLE_ASCII_MAP);
            }
        }
        return new Font("\u5b8b\u4f53", "\u5b8b\u4f53");
    }

    static {
        NOTO_PRINTABLE_ASCII_WIDTH_MAP = new double[]{0.5, 0.3125, 0.435546875, 0.63818359375, 0.58642578125, 0.8896484375, 0.8701171875, 0.25634765625, 0.333984375, 0.333984375, 0.455078125, 0.74169921875, 0.24072265625, 0.4326171875, 0.24072265625, 0.42724609375, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.58642578125, 0.24072265625, 0.24072265625, 0.74169921875, 0.74169921875, 0.74169921875, 0.48291015625, 1.03125, 0.70361328125, 0.62744140625, 0.6689453125, 0.76171875, 0.5498046875, 0.53125, 0.74365234375, 0.7734375, 0.2939453125, 0.39599609375, 0.634765625, 0.51318359375, 0.97705078125, 0.81298828125, 0.81494140625, 0.61181640625, 0.81494140625, 0.65283203125, 0.5771484375, 0.5732421875, 0.74658203125, 0.67626953125, 1.017578125, 0.64501953125, 0.603515625, 0.6201171875, 0.333984375, 0.416015625, 0.333984375, 0.74169921875, 0.4482421875, 0.294921875, 0.552734375, 0.638671875, 0.50146484375, 0.6396484375, 0.5673828125, 0.3466796875, 0.6396484375, 0.61572265625, 0.26611328125, 0.26708984375, 0.54443359375, 0.26611328125, 0.93701171875, 0.6162109375, 0.6357421875, 0.638671875, 0.6396484375, 0.3818359375, 0.462890625, 0.37255859375, 0.6162109375, 0.52490234375, 0.78955078125, 0.5068359375, 0.529296875, 0.49169921875, 0.333984375, 0.26904296875, 0.333984375, 0.74169921875};
        TIMES_NEW_ROMAN_PRINTABLE_ASCII_MAP = new double[]{0.25, 0.3330078125, 0.408203125, 0.5, 0.5, 0.8330078125, 0.77783203125, 0.18017578125, 0.3330078125, 0.3330078125, 0.5, 0.56396484375, 0.25, 0.3330078125, 0.25, 0.27783203125, 0.5, 0.46326171875, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.27783203125, 0.27783203125, 0.56396484375, 0.56396484375, 0.56396484375, 0.44384765625, 0.9208984375, 0.72216796875, 0.6669921875, 0.6669921875, 0.72216796875, 0.61083984375, 0.55615234375, 0.72216796875, 0.72216796875, 0.3330078125, 0.38916015625, 0.72216796875, 0.61083984375, 0.88916015625, 0.72216796875, 0.72216796875, 0.55615234375, 0.72216796875, 0.6669921875, 0.55615234375, 0.61083984375, 0.72216796875, 0.72216796875, 0.94384765625, 0.72216796875, 0.72216796875, 0.61083984375, 0.3330078125, 0.27783203125, 0.3330078125, 0.46923828125, 0.5, 0.3330078125, 0.44384765625, 0.5, 0.44384765625, 0.5, 0.44384765625, 0.3151220703125, 0.5, 0.5, 0.27783203125, 0.27783203125, 0.5, 0.27783203125, 0.77783203125, 0.5, 0.5, 0.5, 0.5, 0.3330078125, 0.38916015625, 0.27783203125, 0.5, 0.5, 0.72216796875, 0.5, 0.5, 0.44384765625, 0.47998046875, 0.2001953125, 0.47998046875, 0.541015625};
    }
}

