/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Arrays;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.AggregateRealmConfiguration;
import org.infinispan.server.configuration.security.DistributedRealmConfiguration;
import org.infinispan.server.configuration.security.RealmProviderBuilder;
import org.wildfly.security.auth.server.NameRewriter;

public class AggregateRealmConfigurationBuilder
implements RealmProviderBuilder<AggregateRealmConfiguration> {
    private final AttributeSet attributes = AggregateRealmConfiguration.attributeDefinitionSet();

    public AttributeSet attributes() {
        return this.attributes;
    }

    public AggregateRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(DistributedRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(DistributedRealmConfiguration.NAME).get();
    }

    public AggregateRealmConfigurationBuilder authnRealm(String realm) {
        this.attributes.attribute(AggregateRealmConfiguration.AUTHN_REALM).set((Object)realm);
        return this;
    }

    public AggregateRealmConfigurationBuilder nameRewriter(NameRewriter nameRewriter) {
        this.attributes.attribute(AggregateRealmConfiguration.NAME_REWRITER).set((Object)nameRewriter);
        return this;
    }

    public AggregateRealmConfigurationBuilder authzRealms(String[] realms) {
        this.attributes.attribute(AggregateRealmConfiguration.AUTHZ_REALMS).set(Arrays.asList(realms));
        return this;
    }

    public AggregateRealmConfiguration create() {
        return new AggregateRealmConfiguration(this.attributes.protect());
    }

    public Builder<?> read(AggregateRealmConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    @Override
    public int compareTo(RealmProviderBuilder o) {
        return 1;
    }
}

