/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.set.SINTER;

public class SUNION
extends RespCommand
implements Resp3Command {
    public SUNION() {
        super(-2, 1, -1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        Set<byte[]> uniqueKeys = SINTER.getUniqueKeys(handler, arguments);
        CompletableFuture allEntries = esc.getAll(uniqueKeys);
        return handler.stageToReturn(allEntries.thenApply(sets -> SUNION.union(sets.values())), ctx, Consumers.COLLECTION_BULK_BICONSUMER);
    }

    public static List<byte[]> union(Collection<SetBucket<byte[]>> sets) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (SetBucket<byte[]> setBucket : sets) {
            if (setBucket == null) continue;
            for (byte[] el : setBucket.toSet()) {
                if (el == null || result.stream().anyMatch(v -> Objects.deepEquals(v, el))) continue;
                result.add(el);
            }
        }
        return result;
    }
}

