/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.SearchTimeoutException;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.TotalHitCount;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.ScrollerIteratorAdaptor;

public class IndexedQueryImpl<E>
implements IndexedQuery<E> {
    private static final int SCROLL_CHUNK = 100;
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected final QueryDefinition queryDefinition;
    protected final LocalQueryStatistics queryStatistics;

    public IndexedQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache, LocalQueryStatistics queryStatistics) {
        this.queryDefinition = queryDefinition;
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
        this.queryStatistics = queryStatistics;
    }

    public IndexedQueryImpl(String queryString, IckleParsingResult.StatementType statementType, SearchQueryBuilder searchQuery, AdvancedCache<?, ?> cache, LocalQueryStatistics queryStatistics, int defaultMaxResults) {
        this(new QueryDefinition(queryString, statementType, searchQuery, defaultMaxResults), cache, queryStatistics);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQueryBuilder().build();
        return Math.toIntExact(searchQuery.fetchTotalHitCount());
    }

    @Override
    public IndexedQuery<E> firstResult(int firstResult) {
        this.queryDefinition.setFirstResult(firstResult);
        return this;
    }

    @Override
    public IndexedQuery<E> maxResults(int maxResults) {
        this.queryDefinition.setMaxResults(maxResults);
        return this;
    }

    @Override
    public IndexedQuery<E> hitCountAccuracy(int hitCountAccuracy) {
        this.queryDefinition.setHitCountAccuracy(hitCountAccuracy);
        return this;
    }

    private void recordQuery(long nanos) {
        this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), nanos);
    }

    @Override
    public CloseableIterator<E> iterator() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQueryBuilder().build();
        MappingIterator iterator = new MappingIterator(this.iterator((SearchQuery)searchQuery)).skip((long)this.queryDefinition.getFirstResult()).limit((long)this.queryDefinition.getMaxResults());
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(System.nanoTime() - start);
        }
        return iterator;
    }

    @Override
    public <K> CloseableIterator<EntityEntry<K, E>> entryIterator() {
        this.partitionHandlingSupport.checkCacheAvailable();
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        SearchQueryBuilder searchQueryBuilder = this.queryDefinition.getSearchQueryBuilder();
        if (!searchQueryBuilder.isEntityProjection()) {
            throw Log.CONTAINER.entryIteratorDoesNotAllowProjections();
        }
        LuceneSearchQuery<List<Object>> searchQuery = this.queryDefinition.isScoreRequired() ? searchQueryBuilder.keyEntityAndScore() : searchQueryBuilder.keyAndEntity();
        MappingIterator iterator = new MappingIterator(this.iterator((SearchQuery)searchQuery), this::mapToEntry);
        iterator.skip((long)this.queryDefinition.getFirstResult()).limit((long)this.queryDefinition.getMaxResults());
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(System.nanoTime() - start);
        }
        return iterator;
    }

    private <K, V> EntityEntry<K, V> mapToEntry(List<Object> projection) {
        float score = projection.size() > 2 ? ((Float)projection.get(2)).floatValue() : Float.NaN;
        return new EntityEntry(((EntityReference)projection.get(0)).id(), projection.get(1), score);
    }

    @Override
    public QueryResult<?> execute() {
        if (this.queryDefinition.getStatementType() != IckleParsingResult.StatementType.SELECT) {
            return new QueryResultImpl(this.executeStatement(), Collections.emptyList());
        }
        try {
            this.partitionHandlingSupport.checkCacheAvailable();
            SearchQueryBuilder searchQueryBuilder = this.queryDefinition.getSearchQueryBuilder();
            if (searchQueryBuilder.aggregation() != null) {
                return this.aggregation();
            }
            long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
            LuceneSearchQuery<?> searchQuery = searchQueryBuilder.build();
            SearchResult searchResult = searchQuery.fetch(Integer.valueOf(this.queryDefinition.getFirstResult()), Integer.valueOf(this.queryDefinition.getMaxResults()));
            if (this.queryStatistics.isEnabled()) {
                this.recordQuery(System.nanoTime() - start);
            }
            return new QueryResultImpl(new TotalHitCount((int)searchResult.total().hitCountLowerBound(), searchResult.total().isHitCountExact()), searchResult.hits());
        }
        catch (org.hibernate.search.util.common.SearchTimeoutException timeoutException) {
            throw new SearchTimeoutException();
        }
    }

    public QueryResult<?> aggregation() {
        TreeMap aggregation;
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        SearchQueryBuilder searchQueryBuilder = this.queryDefinition.getSearchQueryBuilder();
        LuceneSearchQuery<?> searchQuery = searchQueryBuilder.build();
        SearchResult searchResult = searchQuery.fetch(Integer.valueOf(0), Integer.valueOf(0));
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(System.nanoTime() - start);
        }
        TreeMap aggregationResult = (TreeMap)searchResult.aggregation(AggregationKey.of((String)"InfinispanSingletonKey"));
        Sort sort = searchQueryBuilder.getLuceneSort();
        if (sort.getSort().length == 1) {
            aggregation = sort.getSort()[0].getReverse() ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
            aggregation.putAll(aggregationResult);
        } else {
            aggregation = aggregationResult;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(aggregation.size());
        boolean displayGroupFirst = searchQueryBuilder.aggregation().displayGroupFirst();
        for (Map.Entry groupAggregation : aggregation.entrySet()) {
            if (displayGroupFirst) {
                result.add(new Object[]{groupAggregation.getKey(), groupAggregation.getValue()});
                continue;
            }
            result.add(new Object[]{groupAggregation.getValue(), groupAggregation.getKey()});
        }
        return new QueryResultImpl(new TotalHitCount((int)searchResult.total().hitCountLowerBound(), searchResult.total().isHitCountExact()), result);
    }

    @Override
    public int executeStatement() {
        if (this.queryDefinition.getStatementType() != IckleParsingResult.StatementType.DELETE) {
            throw Log.CONTAINER.unsupportedStatement();
        }
        if (this.queryDefinition.getFirstResult() != 0 || this.queryDefinition.isCustomMaxResults()) {
            throw Log.CONTAINER.deleteStatementsCannotUsePaging();
        }
        try {
            this.partitionHandlingSupport.checkCacheAvailable();
            long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
            SearchQueryBuilder searchQueryBuilder = this.queryDefinition.getSearchQueryBuilder();
            LuceneSearchQuery<Object> searchQuery = searchQueryBuilder.ids();
            List hits = searchQuery.fetchAllHits();
            int count = 0;
            for (Object id : hits) {
                Object removed = this.cache.remove(id);
                if (removed == null) continue;
                ++count;
            }
            if (this.queryStatistics.isEnabled()) {
                this.recordQuery(System.nanoTime() - start);
            }
            return count;
        }
        catch (org.hibernate.search.util.common.SearchTimeoutException timeoutException) {
            throw new SearchTimeoutException();
        }
    }

    private <T> CloseableIterator<T> iterator(SearchQuery<T> searchQuery) {
        try {
            return new ScrollerIteratorAdaptor(searchQuery.scroll(100));
        }
        catch (org.hibernate.search.util.common.SearchTimeoutException timeoutException) {
            throw new SearchTimeoutException();
        }
    }

    @Override
    public IndexedQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.failAfter(timeout, timeUnit);
        return this;
    }

    @Override
    public void scoreRequired() {
        this.queryDefinition.scoreRequired();
    }
}

