/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;

public final class SRemoveFunction<K, V>
implements SetBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<SRemoveFunction> EXTERNALIZER = new Externalizer();
    private final Collection<V> values;

    public SRemoveFunction(Collection<V> values) {
        this.values = values;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        Long removed = 0L;
        if (!existing.isPresent()) {
            return 0L;
        }
        SetBucket s = (SetBucket)existing.get();
        int initSize = s.size();
        if (s.removeAll(this.values)) {
            removed = initSize - s.size();
        }
        if (removed > 0L) {
            if (!s.isEmpty()) {
                entryView.set((Object)s, new MetaParam.Writable[0]);
            } else {
                entryView.remove();
            }
        }
        return removed;
    }

    public Collection<V> values() {
        return this.values;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SRemoveFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SRemoveFunction>> getTypeClasses() {
            return Collections.singleton(SRemoveFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_REMOVE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SRemoveFunction object) throws IOException {
            output.writeInt(object.values().size());
            for (Object v : object.values()) {
                output.writeObject(v);
            }
        }

        public SRemoveFunction<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(input.readObject());
            }
            return new SRemoveFunction(list);
        }
    }
}

