/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents.configuration;

import org.infinispan.cloudevents.configuration.CloudEventsGlobalConfigurationBuilder;
import org.infinispan.cloudevents.configuration.CloudEventsGlobalConfigurationSerializer;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Experimental;
import org.infinispan.configuration.serializing.SerializedWith;

@SerializedWith(value=CloudEventsGlobalConfigurationSerializer.class)
@BuiltBy(value=CloudEventsGlobalConfigurationBuilder.class)
@Experimental
public class CloudEventsGlobalConfiguration {
    static final AttributeDefinition<String> BOOTSTRAP_SERVERS = AttributeDefinition.builder((String)"bootstrap-servers", (Object)"").immutable().build();
    static final AttributeDefinition<String> ACKS = AttributeDefinition.builder((String)"acks", (Object)"all").immutable().build();
    static final AttributeDefinition<String> CACHE_ENTRIES_TOPIC = AttributeDefinition.builder((String)"cache-entries-topic", (Object)"").immutable().build();
    static final AttributeDefinition<String> AUDIT_TOPIC = AttributeDefinition.builder((String)"audit-topic", (Object)"").immutable().build();
    private final AttributeSet attributes;

    CloudEventsGlobalConfiguration(AttributeSet attributeSet) {
        this.attributes = attributeSet.checkProtection();
    }

    static AttributeSet attributeSet() {
        return new AttributeSet(CloudEventsGlobalConfiguration.class, new AttributeDefinition[]{BOOTSTRAP_SERVERS, ACKS, AUDIT_TOPIC, CACHE_ENTRIES_TOPIC});
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String bootstrapServers() {
        return (String)this.attributes.attribute(BOOTSTRAP_SERVERS).get();
    }

    public String acks() {
        return (String)this.attributes.attribute(ACKS).get();
    }

    public String auditTopic() {
        return (String)this.attributes.attribute(AUDIT_TOPIC).get();
    }

    public String cacheEntriesTopic() {
        return (String)this.attributes.attribute(CACHE_ENTRIES_TOPIC).get();
    }

    public String toString() {
        return "CloudEventsGlobalConfiguration [attributes=" + String.valueOf(this.attributes) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEventsGlobalConfiguration that = (CloudEventsGlobalConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean auditEventsEnabled() {
        return !this.auditTopic().isEmpty();
    }

    public boolean cacheEntryEventsEnabled() {
        return !this.cacheEntriesTopic().isEmpty();
    }
}

