/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.KeyStoreConfiguration;
import org.infinispan.persistence.remote.configuration.TrustStoreConfiguration;

public class SslConfiguration
extends ConfigurationElement<SslConfiguration> {
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false, Boolean.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<SSLContext> SSL_CONTEXT = AttributeDefinition.builder((String)"sslContext", null, SSLContext.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SNI_HOSTNAME = AttributeDefinition.builder((Enum)Attribute.SNI_HOSTNAME, null, String.class).immutable().build();
    static final AttributeDefinition<Boolean> HOSTNAME_VALIDATION = AttributeDefinition.builder((String)"ssl-hostname-validation", (Object)true).immutable().build();
    static final AttributeDefinition<String> PROTOCOL = AttributeDefinition.builder((Enum)Attribute.PROTOCOL, null, String.class).immutable().build();
    private final KeyStoreConfiguration keyStoreConfiguration;
    private final TrustStoreConfiguration trustStoreConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SslConfiguration.class, new AttributeDefinition[]{ENABLED, SNI_HOSTNAME, HOSTNAME_VALIDATION, PROTOCOL});
    }

    SslConfiguration(AttributeSet attributes, KeyStoreConfiguration keyStoreConfiguration, TrustStoreConfiguration trustStoreConfiguration) {
        super((Enum)Element.ENCRYPTION, attributes, new ConfigurationElement[]{keyStoreConfiguration, trustStoreConfiguration});
        this.keyStoreConfiguration = keyStoreConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
    }

    public KeyStoreConfiguration keyStoreConfiguration() {
        return this.keyStoreConfiguration;
    }

    public TrustStoreConfiguration trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public String keyStoreFileName() {
        return this.keyStoreConfiguration.keyStoreFileName();
    }

    public String keyStoreType() {
        return this.keyStoreConfiguration.keyStoreType();
    }

    public char[] keyStorePassword() {
        return this.keyStoreConfiguration.keyStorePassword();
    }

    public String keyAlias() {
        return this.keyStoreConfiguration.keyAlias();
    }

    public SSLContext sslContext() {
        return (SSLContext)this.attributes.attribute(SSL_CONTEXT).get();
    }

    public String trustStoreFileName() {
        return this.trustStoreConfiguration.trustStoreFileName();
    }

    public String trustStoreType() {
        return this.trustStoreConfiguration.trustStoreType();
    }

    public char[] trustStorePassword() {
        return this.trustStoreConfiguration.trustStorePassword();
    }

    public boolean hostnameValidation() {
        return (Boolean)this.attributes.attribute(HOSTNAME_VALIDATION).get();
    }

    public String sniHostName() {
        return (String)this.attributes.attribute(SNI_HOSTNAME).get();
    }

    public String protocol() {
        return (String)this.attributes.attribute(PROTOCOL).get();
    }
}

