/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml.format;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.FileSet;

public class FormatFileSet
extends FileSet {
    private static final long serialVersionUID = 2128636607981252229L;
    private static final List<String> DEFAULT_INCLUDED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("xml", "xsl"));
    public static final List<String> DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList("**/.*"));
    private String encoding;
    private int indentSize;

    public static FormatFileSet getDefault(File baseDir, String encoding, int indentSize) {
        FormatFileSet result = new FormatFileSet();
        result.setDirectory(baseDir.getAbsolutePath());
        result.setEncoding(encoding);
        result.setIndentSize(indentSize);
        ArrayList<String> includes = new ArrayList<String>(DEFAULT_INCLUDED_EXTENSIONS.size() * 2);
        for (String ext : DEFAULT_INCLUDED_EXTENSIONS) {
            includes.add("*." + ext);
            includes.add("src/**/*." + ext);
        }
        result.setIncludes(includes);
        result.setExcludes(DEFAULT_EXCLUDES);
        return result;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }
}

