/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedAlgorithmStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingTableRulesUsedAlgorithmQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        ShowShardingTableRulesUsedAlgorithmStatement statement = (ShowShardingTableRulesUsedAlgorithmStatement)sqlStatement;
        ArrayList result = new ArrayList();
        Collection shardingTableRules = metaData.getRuleMetaData().findRuleConfiguration(ShardingRuleConfiguration.class);
        shardingTableRules.forEach(each -> this.requireResult(statement, metaData.getName(), result, (ShardingRuleConfiguration)each));
        this.data = result.iterator();
    }

    private void requireResult(ShowShardingTableRulesUsedAlgorithmStatement statement, String schemaName, List<Collection<Object>> result, ShardingRuleConfiguration shardingRuleConfiguration) {
        if (!statement.getAlgorithmName().isPresent()) {
            return;
        }
        shardingRuleConfiguration.getTables().forEach(each -> {
            if (null != each.getDatabaseShardingStrategy() && ((String)statement.getAlgorithmName().get()).equals(each.getDatabaseShardingStrategy().getShardingAlgorithmName()) || null != each.getTableShardingStrategy() && ((String)statement.getAlgorithmName().get()).equals(each.getTableShardingStrategy().getShardingAlgorithmName())) {
                result.add(Arrays.asList(schemaName, "table", each.getLogicTable()));
            }
        });
        shardingRuleConfiguration.getAutoTables().forEach(each -> {
            if (null != each.getShardingStrategy() && ((String)statement.getAlgorithmName().get()).equals(each.getShardingStrategy().getShardingAlgorithmName())) {
                result.add(Arrays.asList(schemaName, "auto_table", each.getLogicTable()));
            }
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("schema", "type", "name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowShardingTableRulesUsedAlgorithmStatement.class.getName();
    }
}

