/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.enums;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;

public enum ShardingStrategyType {
    STANDARD{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new StandardShardingStrategyConfiguration(shardingColumn, shardingAlgorithmName);
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return StandardShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfiguration) {
            return Arrays.asList(((StandardShardingStrategyConfiguration)strategyConfiguration).getShardingColumn(), strategyConfiguration.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return null != shardingColumn && !shardingColumn.contains(",");
        }
    }
    ,
    NONE{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new NoneShardingStrategyConfiguration();
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return NoneShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfiguration) {
            return Arrays.asList("", strategyConfiguration.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return true;
        }
    }
    ,
    HINT{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new HintShardingStrategyConfiguration(shardingAlgorithmName);
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return HintShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfiguration) {
            return Arrays.asList("", strategyConfiguration.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return true;
        }
    }
    ,
    COMPLEX{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new ComplexShardingStrategyConfiguration(shardingColumn, shardingAlgorithmName);
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return ComplexShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfiguration) {
            return Arrays.asList(((ComplexShardingStrategyConfiguration)strategyConfiguration).getShardingColumns(), strategyConfiguration.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return null != shardingColumn && shardingColumn.split(",").length > 1;
        }
    };


    public abstract ShardingStrategyConfiguration createConfiguration(String var1, String var2);

    public abstract Class<? extends ShardingStrategyConfiguration> getImplementedClass();

    public abstract Collection<String> getConfigurationContents(ShardingStrategyConfiguration var1);

    public abstract boolean isValid(String var1);

    public static ShardingStrategyType getValueOf(String name) {
        try {
            return ShardingStrategyType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("unsupported strategy type %s", name));
        }
    }

    public static ShardingStrategyType getValueOf(ShardingStrategyConfiguration shardingStrategyConfiguration) {
        Optional<ShardingStrategyType> type = Arrays.stream(ShardingStrategyType.values()).filter(each -> shardingStrategyConfiguration.getClass().getCanonicalName().equals(each.getImplementedClass().getCanonicalName())).findFirst();
        type.orElseThrow(() -> new UnsupportedOperationException(String.format("unsupported strategy type %s", shardingStrategyConfiguration.getClass().getName())));
        return type.get();
    }

    public static boolean contain(String name) {
        return Arrays.stream(ShardingStrategyType.values()).map(Enum::name).anyMatch(each -> each.equalsIgnoreCase(name));
    }
}

