/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDisabledException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.distsql.statement.DisableShardingScalingRuleStatement;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;

public final class DisableShardingScalingRuleStatementUpdater
implements RuleDefinitionAlterUpdater<DisableShardingScalingRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DisableShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkExist(schemaName, sqlStatement, currentRuleConfig);
        this.checkDisabled(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", schemaName);
        }
    }

    private void checkExist(String schemaName, DisableShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!currentRuleConfig.getScaling().containsKey(sqlStatement.getScalingName())) {
            throw new RequiredRuleMissedException("Scaling", schemaName, sqlStatement.getScalingName());
        }
    }

    private void checkDisabled(String schemaName, DisableShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig.getScalingName() || !currentRuleConfig.getScalingName().equals(sqlStatement.getScalingName())) {
            throw new RuleDisabledException("Scaling", schemaName, sqlStatement.getScalingName());
        }
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(DisableShardingScalingRuleStatement sqlStatement) {
        return null;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.setScalingName(null);
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DisableShardingScalingRuleStatement.class.getName();
    }
}

