/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class SQL92DataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = -1;
    private final String hostname;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Pattern pattern = Pattern.compile("jdbc:.*", 2);

    public SQL92DataSourceMetaData(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (!matcher.find()) {
            throw new UnrecognizedDatabaseURLException(url, this.pattern.pattern());
        }
        this.hostname = "";
        this.port = -1;
        this.catalog = "";
        this.schema = null;
    }

    @Override
    public Properties getQueryProperties() {
        return new Properties();
    }

    @Override
    public Properties getDefaultQueryProperties() {
        return new Properties();
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }
}

