/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster;

import com.google.common.base.Preconditions;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class ClusterPersistRepositoryFactory {
    public static ClusterPersistRepository newInstance(ClusterPersistRepositoryConfiguration config, InstanceDefinition instanceDefinition) {
        Preconditions.checkNotNull((Object)config, (Object)"Cluster persist repository configuration cannot be null.");
        ClusterPersistRepository result = (ClusterPersistRepository)TypedSPIRegistry.getRegisteredService(ClusterPersistRepository.class, (String)config.getType(), (Properties)config.getProps());
        result.init(config);
        result.watchSessionConnection(instanceDefinition);
        return result;
    }

    @Generated
    private ClusterPersistRepositoryFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(ClusterPersistRepository.class);
    }
}

