/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.kamelets.utils.format.spi.annotations.DataType;
import org.apache.camel.util.ObjectHelper;

@DataType(name="jsonObject", mediaType="application/json")
public class JsonModelDataType
implements DataTypeConverter,
CamelContextAware {
    public static final String DATA_TYPE_MODEL_PROPERTY = "CamelDataTypeModel";
    private String model;
    private CamelContext camelContext;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public void convert(Exchange exchange) {
        String type = exchange.hasProperties() && exchange.getProperties().containsKey(DATA_TYPE_MODEL_PROPERTY) ? (String)exchange.getProperty(DATA_TYPE_MODEL_PROPERTY, String.class) : this.model;
        if (type == null) {
            return;
        }
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        try {
            Object unmarshalled = mapper.reader().forType(this.camelContext.getClassResolver().resolveMandatoryClass(type)).readValue(this.getBodyAsStream(exchange));
            exchange.getMessage().setBody(unmarshalled);
        }
        catch (Exception e) {
            throw new CamelExecutionException(String.format("Failed to load Json unmarshalling type '%s'", type), exchange, (Throwable)e);
        }
    }

    private InputStream getBodyAsStream(Exchange exchange) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)exchange.getMessage().getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])exchange.getMessage().getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

