/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.aws2.s3;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.kamelets.utils.format.spi.annotations.DataType;

@DataType(scheme="aws2-s3", name="cloudevents", mediaType="application/octet-stream")
public class AWS2S3CloudEventOutputType
implements DataTypeConverter {
    static final String CAMEL_CLOUD_EVENT_TYPE = "CamelCloudEventType";
    static final String CAMEL_CLOUD_EVENT_SOURCE = "CamelCloudEventSource";
    static final String CAMEL_CLOUD_EVENT_SUBJECT = "CamelCloudEventSubject";
    static final String CAMEL_CLOUD_EVENT_TIME = "CamelCloudEventTime";

    @Override
    public void convert(Exchange exchange) {
        Map headers = exchange.getMessage().getHeaders();
        headers.put(CAMEL_CLOUD_EVENT_TYPE, "org.apache.camel.event.aws.s3.getObject");
        headers.put(CAMEL_CLOUD_EVENT_SOURCE, "aws.s3.bucket." + (String)exchange.getMessage().getHeader("CamelAwsS3BucketName", String.class));
        headers.put(CAMEL_CLOUD_EVENT_SUBJECT, exchange.getMessage().getHeader("CamelAwsS3Key", String.class));
        headers.put(CAMEL_CLOUD_EVENT_TIME, this.getEventTime(exchange));
    }

    private String getEventTime(Exchange exchange) {
        ZonedDateTime created = ZonedDateTime.ofInstant(Instant.ofEpochMilli(exchange.getCreated()), ZoneId.systemDefault());
        return DateTimeFormatter.ISO_INSTANT.format(created);
    }
}

