/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.aws2.ddb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.kamelets.utils.format.spi.annotations.DataType;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

@DataType(scheme="aws2-ddb", name="json", mediaType="application/json")
public class Ddb2JsonInputType
implements DataTypeConverter {
    private final JacksonDataFormat dataFormat = new JacksonDataFormat(new ObjectMapper(), JsonNode.class);

    @Override
    public void convert(Exchange exchange) {
        if (exchange.getMessage().getHeaders().containsKey("CamelAwsDdbItem") || exchange.getMessage().getHeaders().containsKey("CamelAwsDdbKey")) {
            return;
        }
        JsonNode jsonBody = this.getBodyAsJsonNode(exchange);
        String operation = Optional.ofNullable(jsonBody.get("operation")).map(JsonNode::asText).orElse(Ddb2Operations.PutItem.name());
        if (exchange.hasProperties() && exchange.getProperty("operation", String.class) != null) {
            operation = (String)exchange.getProperty("operation", String.class);
        }
        if (exchange.getIn().getHeaders().containsKey("CamelAwsDdbOperation")) {
            operation = ((Ddb2Operations)exchange.getIn().getHeader("CamelAwsDdbOperation", Ddb2Operations.class)).name();
        }
        JsonNode key = jsonBody.get("key");
        JsonNode item = jsonBody.get("item");
        Map keyProps = key != null ? (Map)this.dataFormat.getObjectMapper().convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){}) : (Map)this.dataFormat.getObjectMapper().convertValue((Object)jsonBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map itemProps = item != null ? (Map)this.dataFormat.getObjectMapper().convertValue((Object)item, (TypeReference)new TypeReference<Map<String, Object>>(){}) : keyProps;
        Map<String, AttributeValue> keyMap = this.getAttributeValueMap(keyProps);
        switch (Ddb2Operations.valueOf((String)operation)) {
            case PutItem: {
                exchange.getMessage().setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.PutItem);
                exchange.getMessage().setHeader("CamelAwsDdbItem", this.getAttributeValueMap(itemProps));
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_OLD.toString(), exchange);
                break;
            }
            case UpdateItem: {
                exchange.getMessage().setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.UpdateItem);
                exchange.getMessage().setHeader("CamelAwsDdbKey", keyMap);
                exchange.getMessage().setHeader("CamelAwsDdbUpdateValues", this.getAttributeValueUpdateMap(itemProps));
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_NEW.toString(), exchange);
                break;
            }
            case DeleteItem: {
                exchange.getMessage().setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.DeleteItem);
                exchange.getMessage().setHeader("CamelAwsDdbKey", keyMap);
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_OLD.toString(), exchange);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported operation '%s'", operation));
            }
        }
    }

    private JsonNode getBodyAsJsonNode(Exchange exchange) {
        try {
            if (exchange.getMessage().getBody() instanceof JsonNode) {
                return (JsonNode)exchange.getMessage().getMandatoryBody(JsonNode.class);
            }
            return (JsonNode)this.dataFormat.unmarshal(exchange, (InputStream)exchange.getMessage().getMandatoryBody(InputStream.class));
        }
        catch (Exception e) {
            throw new CamelExecutionException("Failed to get mandatory Json node from message body", exchange, (Throwable)e);
        }
    }

    private void setHeaderIfNotPresent(String headerName, Object value, Exchange exchange) {
        exchange.getMessage().setHeader(headerName, value);
    }

    private Map<String, AttributeValue> getAttributeValueMap(Map<String, Object> body) {
        LinkedHashMap<String, AttributeValue> attributeValueMap = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> attribute : body.entrySet()) {
            attributeValueMap.put(attribute.getKey(), Ddb2JsonInputType.getAttributeValue(attribute.getValue()));
        }
        return attributeValueMap;
    }

    private Map<String, AttributeValueUpdate> getAttributeValueUpdateMap(Map<String, Object> body) {
        LinkedHashMap<String, AttributeValueUpdate> attributeValueMap = new LinkedHashMap<String, AttributeValueUpdate>();
        for (Map.Entry<String, Object> attribute : body.entrySet()) {
            attributeValueMap.put(attribute.getKey(), Ddb2JsonInputType.getAttributeValueUpdate(attribute.getValue()));
        }
        return attributeValueMap;
    }

    private static AttributeValue getAttributeValue(Object value) {
        if (value == null) {
            return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        }
        if (value instanceof String) {
            return (AttributeValue)AttributeValue.builder().s(value.toString()).build();
        }
        if (value instanceof Integer) {
            return (AttributeValue)AttributeValue.builder().n(value.toString()).build();
        }
        if (value instanceof Boolean) {
            return (AttributeValue)AttributeValue.builder().bool((Boolean)value).build();
        }
        if (value instanceof String[]) {
            return (AttributeValue)AttributeValue.builder().ss((String[])value).build();
        }
        if (value instanceof int[]) {
            return (AttributeValue)AttributeValue.builder().ns((Collection)Stream.of((int[])value).map(Object::toString).collect(Collectors.toList())).build();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.isEmpty()) {
                return (AttributeValue)AttributeValue.builder().ss(new String[0]).build();
            }
            if (values.get(0) instanceof Integer) {
                return (AttributeValue)AttributeValue.builder().ns((Collection)values.stream().map(Object::toString).collect(Collectors.toList())).build();
            }
            return (AttributeValue)AttributeValue.builder().ss((Collection)values.stream().map(Object::toString).collect(Collectors.toList())).build();
        }
        if (value instanceof Map) {
            LinkedHashMap<String, AttributeValue> nestedAttributes = new LinkedHashMap<String, AttributeValue>();
            for (Map.Entry nested : ((Map)value).entrySet()) {
                nestedAttributes.put(nested.getKey().toString(), Ddb2JsonInputType.getAttributeValue(nested.getValue()));
            }
            return (AttributeValue)AttributeValue.builder().m(nestedAttributes).build();
        }
        return (AttributeValue)AttributeValue.builder().s(value.toString()).build();
    }

    private static AttributeValueUpdate getAttributeValueUpdate(Object value) {
        return (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(Ddb2JsonInputType.getAttributeValue(value)).build();
    }
}

