/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.kamelets.utils.format.DefaultDataTypeRegistry;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeProcessor
implements Processor,
CamelContextAware {
    public static final String DATA_TYPE_FORMAT_PROPERTY = "CamelDataTypeFormat";
    private static final Logger LOG = LoggerFactory.getLogger(DataTypeProcessor.class);
    private CamelContext camelContext;
    private DefaultDataTypeRegistry registry;
    private String scheme;
    private String format;
    private boolean ignoreMissingDataType = false;
    private DataTypeConverter converter;

    public void process(Exchange exchange) throws Exception {
        if (exchange.hasProperties() && exchange.getProperties().containsKey(DATA_TYPE_FORMAT_PROPERTY)) {
            this.format = (String)exchange.getProperty(DATA_TYPE_FORMAT_PROPERTY, String.class);
        }
        if (this.format == null || this.format.isEmpty()) {
            return;
        }
        Optional<DataTypeConverter> dataTypeConverter = this.doConverterLookup();
        dataTypeConverter.ifPresent(converter -> converter.convert(exchange));
        if (!dataTypeConverter.isPresent()) {
            LOG.debug("Unable to find data type for scheme {} and format name {}", (Object)this.scheme, (Object)this.format);
            if (!this.ignoreMissingDataType) {
                throw new CamelExecutionException(String.format("Missing data type for scheme %s and format name %s", this.scheme, this.format), exchange);
            }
        }
    }

    private Optional<DataTypeConverter> doConverterLookup() {
        if (this.converter != null) {
            return Optional.of(this.converter);
        }
        Optional<DataTypeConverter> maybeConverter = this.registry.lookup(this.scheme, this.format);
        maybeConverter.ifPresent(dataTypeConverter -> {
            this.converter = dataTypeConverter;
        });
        return maybeConverter;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setRegistry(DefaultDataTypeRegistry dataTypeRegistry) {
        this.registry = dataTypeRegistry;
    }

    public void setIgnoreMissingDataType(boolean ignoreMissingDataType) {
        this.ignoreMissingDataType = ignoreMissingDataType;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

