/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.kamelets.utils.format.spi.DataTypeLoader;
import org.apache.camel.kamelets.utils.format.spi.DataTypeRegistry;
import org.apache.camel.kamelets.utils.format.spi.annotations.DataType;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDataTypeLoader
implements DataTypeLoader,
CamelContextAware {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/DataTypeConverter";
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationDataTypeLoader.class);
    private CamelContext camelContext;
    protected PackageScanClassResolver resolver;
    protected Set<Class<?>> visitedClasses = new HashSet();
    protected Set<String> visitedURIs = new HashSet<String>();

    @Override
    public void load(DataTypeRegistry registry) {
        Set scannedClasses;
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        if (this.resolver == null) {
            this.resolver = this.camelContext instanceof ExtendedCamelContext ? ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getPackageScanClassResolver() : new DefaultPackageScanClassResolver();
        }
        HashSet<String> packages = new HashSet<String>();
        LOG.trace("Searching for {} services", (Object)META_INF_SERVICES);
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.findPackages(packages, ccl);
            }
            this.findPackages(packages, this.getClass().getClassLoader());
            if (packages.isEmpty()) {
                LOG.debug("No package names found to be used for classpath scanning for annotated data types.");
                return;
            }
        }
        catch (Exception e) {
            throw new TypeConverterLoaderException("Cannot find package names to be used for classpath scanning for annotated data types.", (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found data type packages to scan: {}", (Object)String.join((CharSequence)", ", packages));
        }
        if (!(scannedClasses = this.resolver.findAnnotated(DataType.class, packages.toArray(new String[0]))).isEmpty()) {
            LOG.debug("Found {} packages with {} @DataType classes to load", (Object)packages.size(), (Object)scannedClasses.size());
            for (Class type : scannedClasses) {
                if (!this.acceptClass(type)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loading data type annotation: {}", (Object)ObjectHelper.name((Class)type));
                }
                this.loadDataType(registry, type);
            }
        }
        this.visitedClasses.clear();
        this.visitedURIs.clear();
    }

    private void loadDataType(DataTypeRegistry registry, Class<?> type) {
        if (this.visitedClasses.contains(type)) {
            return;
        }
        this.visitedClasses.add(type);
        try {
            if (DataTypeConverter.class.isAssignableFrom(type) && type.isAnnotationPresent(DataType.class)) {
                DataType dt = type.getAnnotation(DataType.class);
                DataTypeConverter converter = (DataTypeConverter)this.camelContext.getInjector().newInstance(type);
                registry.addDataTypeConverter(dt.scheme(), converter);
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("Ignoring converter type: {} as a dependent class could not be found: {}", new Object[]{type.getCanonicalName(), e, e});
        }
    }

    protected boolean acceptClass(Class<?> type) {
        return true;
    }

    protected void findPackages(Set<String> packages, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String path = url.getPath();
            if (this.visitedURIs.contains(path)) continue;
            this.visitedURIs.add(path);
            LOG.debug("Loading file {} to retrieve list of packages, from url: {}", (Object)META_INF_SERVICES, (Object)url);
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    packages.add(line);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

