/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Exchange;
import org.apache.camel.component.metrics.AbstractMetricsProducer;
import org.apache.camel.component.metrics.MetricsEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeProducer
extends AbstractMetricsProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GaugeProducer.class);

    public GaugeProducer(MetricsEndpoint endpoint) {
        super(endpoint);
        Gauge gauge = (Gauge)endpoint.getRegistry().getGauges().get(endpoint.getMetricsName());
        if (gauge instanceof CamelMetricsGauge) {
            CamelMetricsGauge camelMetricsGauge = (CamelMetricsGauge)gauge;
            if (endpoint.getSubject() != null) {
                camelMetricsGauge.setValue(endpoint.getSubject());
            }
        } else if (endpoint.getSubject() != null) {
            endpoint.getRegistry().register(endpoint.getMetricsName(), (Metric)new CamelMetricsGauge(endpoint.getSubject()));
        } else {
            LOG.info("No subject found for Gauge \"{}\". Ignoring...", (Object)endpoint.getMetricsName());
        }
    }

    @Override
    protected void doProcess(Exchange exchange, MetricsEndpoint endpoint, MetricRegistry registry, String metricsName) throws Exception {
        Gauge gauge = (Gauge)registry.getGauges().get(metricsName);
        if (gauge instanceof CamelMetricsGauge) {
            CamelMetricsGauge camelMetricsGauge = (CamelMetricsGauge)gauge;
            Object subject = exchange.getIn().getHeader("CamelMetricsGaugeSubject", Object.class);
            if (subject != null) {
                camelMetricsGauge.setValue(subject);
            }
        } else {
            Object finalSubject;
            Object subject = exchange.getIn().getHeader("CamelMetricsGaugeSubject", Object.class);
            Object object = finalSubject = subject != null ? subject : endpoint.getSubject();
            if (finalSubject != null) {
                registry.register(metricsName, (Metric)new CamelMetricsGauge(finalSubject));
            } else {
                LOG.info("No subject found for Gauge \"{}\". Ignoring...", (Object)metricsName);
            }
        }
    }

    static class CamelMetricsGauge
    implements Gauge<Object> {
        private Object subject;

        CamelMetricsGauge(Object subject) {
            this.subject = subject;
        }

        public Object getValue() {
            return this.subject;
        }

        public void setValue(Object subject) {
            this.subject = subject;
        }
    }
}

