/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.errorhandler;

import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.consumer.errorhandler.SeekUtil;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscardErrorStrategy
implements PollExceptionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DiscardErrorStrategy.class);
    private final Consumer<?, ?> consumer;

    public DiscardErrorStrategy(Consumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    @Override
    public boolean canContinue() {
        return true;
    }

    @Override
    public void handle(long partitionLastOffset, Exception exception) {
        LOG.warn("Requesting the consumer to discard the message and continue to the next based on polling exception strategy");
        SeekUtil.seekToNextOffset(this.consumer, partitionLastOffset);
    }
}

