/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.debug;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzer;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.config.TestCase;
import nl.basjes.parse.useragent.debug.DebugUserAgent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessageFactory;

@DefaultSerializer(value=KryoSerializer.class)
public class AbstractUserAgentAnalyzerTester
extends AbstractUserAgentAnalyzer {
    private static final Logger LOG = LogManager.getFormatterLogger(AbstractUserAgentAnalyzerTester.class);
    private static final MessageFactory MESSAGE_FACTORY = new ReusableMessageFactory();

    public static void configureKryo(Object kryoInstance) {
        Kryo kryo = (Kryo)kryoInstance;
        kryo.register(AbstractUserAgentAnalyzerTester.class);
        AbstractUserAgentAnalyzer.configureKryo(kryo);
    }

    private static String determineLogMessage(String format, Object ... args) {
        if (args == null || args.length == 0) {
            return format;
        }
        return MESSAGE_FACTORY.newMessage(format, args).getFormattedMessage();
    }

    private static void logInfo(StringBuilder errorMessageReceiver, String format, Object ... args) {
        if (LOG.isInfoEnabled()) {
            String message = AbstractUserAgentAnalyzerTester.determineLogMessage(format, args);
            LOG.info(message);
            if (errorMessageReceiver != null) {
                errorMessageReceiver.append(message).append('\n');
            }
        }
    }

    private static void logWarn(StringBuilder errorMessageReceiver, String format, Object ... args) {
        if (LOG.isWarnEnabled()) {
            String message = AbstractUserAgentAnalyzerTester.determineLogMessage(format, args);
            LOG.warn(message);
            if (errorMessageReceiver != null) {
                errorMessageReceiver.append(message).append('\n');
            }
        }
    }

    private static void logError(StringBuilder errorMessageReceiver, String format, Object ... args) {
        if (LOG.isErrorEnabled()) {
            String message = AbstractUserAgentAnalyzerTester.determineLogMessage(format, args);
            LOG.error(message);
            if (errorMessageReceiver != null) {
                errorMessageReceiver.append(message).append('\n');
            }
        }
    }

    public boolean runTests() {
        return this.runTests(false, true);
    }

    public boolean runTests(boolean showAll, boolean failOnUnexpected) {
        return this.runTests(showAll, failOnUnexpected, null, false, false);
    }

    public boolean runTests(boolean showAll, boolean failOnUnexpected, Collection<String> onlyValidateFieldNames, boolean measureSpeed, boolean showPassedTests) {
        return AbstractUserAgentAnalyzerTester.runTests(this, showAll, failOnUnexpected, onlyValidateFieldNames, measureSpeed, showPassedTests, null);
    }

    public static boolean runTests(AbstractUserAgentAnalyzerDirect analyzer, boolean showAll, boolean failOnUnexpected, Collection<String> onlyValidateFieldNames, boolean measureSpeed, boolean showPassedTests, StringBuilder errorMessageReceiver) {
        int filenameHeaderLength;
        analyzer.initializeMatchers();
        if (analyzer.getTestCases() == null) {
            return true;
        }
        DebugUserAgent agent = new DebugUserAgent(analyzer.getWantedFieldNames());
        ArrayList<TestResult> results = new ArrayList<TestResult>(32);
        String filenameHeader = "Test number and source";
        int maxFilenameLength = filenameHeaderLength = filenameHeader.length();
        for (TestCase test : analyzer.getTestCases()) {
            Map<String, String> metaData = test.getMetadata();
            String filename = metaData.get("filename");
            maxFilenameLength = Math.max(maxFilenameLength, filename.length());
        }
        maxFilenameLength += 11;
        StringBuilder sb = new StringBuilder(1024);
        sb.append("| ").append(filenameHeader);
        for (int i = filenameHeaderLength; i < maxFilenameLength; ++i) {
            sb.append(' ');
        }
        sb.append(" |S|AA|MF|");
        if (measureSpeed) {
            sb.append("  PPS| msPP|");
        }
        sb.append("--> S=Syntax Error, AA=Number of ambiguities during parse, MF=Matches Found");
        if (measureSpeed) {
            sb.append(", PPS=parses/sec, msPP=milliseconds per parse");
        }
        long fullStart = System.nanoTime();
        if (showPassedTests) {
            LOG.info("+===========================================================================================");
            LOG.info("%s", (Object)sb);
            LOG.info("+-------------------------------------------------------------------------------------------");
        }
        boolean allPass = true;
        int testcount = 0;
        for (TestCase test : analyzer.getTestCases()) {
            int i;
            int i2;
            ++testcount;
            String testName = test.getTestName();
            String userAgentString = test.getUserAgent();
            Map<String, String> expected = test.getExpected();
            List<String> options = test.getOptions();
            Map<String, String> metaData = test.getMetadata();
            String filename = metaData.get("filename");
            String linenumber = metaData.get("fileline");
            boolean init = false;
            if (options == null) {
                analyzer.setVerbose(false);
                agent.setDebug(false);
            } else {
                boolean newVerbose = options.contains("verbose");
                analyzer.setVerbose(newVerbose);
                agent.setDebug(newVerbose);
                init = options.contains("init");
            }
            if (expected == null || expected.size() == 0) {
                init = true;
                expected = null;
            }
            if (testName == null) {
                testName = userAgentString.length() > 200 ? userAgentString.substring(0, 190) + " ... ( " + userAgentString.length() + " chars)" : userAgentString;
            }
            sb.setLength(0);
            sb.append("|").append(String.format("%5d", testcount)).append(".(").append(filename).append(':').append(linenumber).append(')');
            for (int i3 = filename.length() + linenumber.length() + 7; i3 < maxFilenameLength; ++i3) {
                sb.append(' ');
            }
            agent.setUserAgentString(userAgentString);
            UserAgent.ImmutableUserAgent parseResult = null;
            long measuredSpeed = -1L;
            if (measureSpeed) {
                for (int i4 = 0; i4 < 100; ++i4) {
                    analyzer.parse(agent);
                }
                long startTime = System.nanoTime();
                for (int i5 = 0; i5 < 1000; ++i5) {
                    parseResult = analyzer.parse(agent);
                }
                long stopTime = System.nanoTime();
                measuredSpeed = 1000000000000L / (stopTime - startTime);
            } else {
                parseResult = analyzer.parse(agent);
            }
            sb.append('|');
            if (parseResult.hasSyntaxError()) {
                sb.append('S');
            } else {
                sb.append(' ');
            }
            if (parseResult.hasAmbiguity()) {
                sb.append(String.format("|%2d", parseResult.getAmbiguityCount()));
            } else {
                sb.append("|  ");
            }
            sb.append(String.format("|%2d", agent.getNumberOfAppliedMatches()));
            if (measureSpeed) {
                sb.append('|').append(String.format("%5d", measuredSpeed));
                sb.append('|').append(String.format("%5.2f", 1000.0 / (double)measuredSpeed));
            }
            sb.append("| ").append(testName);
            String testLogLine = sb.toString();
            sb.setLength(0);
            boolean pass = true;
            results.clear();
            if (init) {
                LOG.info(testLogLine);
                sb.append(agent.toYamlTestCase());
                LOG.info("%s", (Object)sb);
            }
            int maxNameLength = 6;
            int maxActualLength = 7;
            int maxExpectedLength = 9;
            if (expected != null) {
                ArrayList<String> fieldNames = new ArrayList<String>(parseResult.getAvailableFieldNamesSorted());
                if (onlyValidateFieldNames != null && onlyValidateFieldNames.isEmpty()) {
                    onlyValidateFieldNames = null;
                } else if (onlyValidateFieldNames != null) {
                    fieldNames.clear();
                    fieldNames.addAll(onlyValidateFieldNames);
                }
                for (String newFieldName : expected.keySet()) {
                    if (fieldNames.contains(newFieldName)) continue;
                    fieldNames.add(newFieldName);
                }
                Iterator<String> iterator = fieldNames.iterator();
                while (iterator.hasNext()) {
                    boolean expectedSomething;
                    String expectedValue;
                    String fieldName = iterator.next();
                    if (onlyValidateFieldNames != null && !onlyValidateFieldNames.contains(fieldName)) continue;
                    TestResult result = new TestResult();
                    result.field = fieldName;
                    result.actual = parseResult.getValue(result.field);
                    result.isDefault = parseResult.get(result.field).isDefaultValue();
                    result.confidence = parseResult.getConfidence(result.field);
                    if (result.actual == null) {
                        result.actual = "<<<null>>>";
                    }
                    if ((expectedValue = expected.get(fieldName)) == null) {
                        expectedSomething = false;
                        if (result.isDefault) continue;
                        result.expected = "<<absent>>";
                    } else {
                        expectedSomething = true;
                        result.expected = expectedValue;
                    }
                    result.pass = result.actual.equals(result.expected);
                    if (!result.pass) {
                        result.warn = true;
                        if (expectedSomething) {
                            result.warn = false;
                            pass = false;
                            allPass = false;
                        } else if (failOnUnexpected && !"__SyntaxError__".equals(result.field)) {
                            result.warn = false;
                            pass = false;
                            allPass = false;
                        }
                    }
                    results.add(result);
                    maxNameLength = Math.max(maxNameLength, result.field.length());
                    maxActualLength = Math.max(maxActualLength, result.actual.length());
                    maxExpectedLength = Math.max(maxExpectedLength, result.expected.length());
                }
                if (!agent.analyzeMatchersResult()) {
                    pass = false;
                    allPass = false;
                }
            }
            if (!init && pass && !showAll) {
                if (!showPassedTests) continue;
                AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, testLogLine, new Object[0]);
                continue;
            }
            if (!pass) {
                AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, testLogLine, new Object[0]);
                AbstractUserAgentAnalyzerTester.logError(errorMessageReceiver, "| TEST FAILED !", new Object[0]);
            }
            if (parseResult.hasAmbiguity()) {
                AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, "| Parsing problem: Ambiguity {} times. ", parseResult.getAmbiguityCount());
            }
            if (parseResult.hasSyntaxError()) {
                AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, "| Parsing problem: Syntax Error", new Object[0]);
            }
            if (init || !pass) {
                sb.setLength(0);
                sb.append('\n');
                sb.append('\n');
                sb.append("- matcher:\n");
                sb.append("#    options:\n");
                sb.append("#    - 'verbose'\n");
                sb.append("    require:\n");
                for (String path : AbstractUserAgentAnalyzerTester.getAllPaths(userAgentString)) {
                    if (!path.contains("=\"")) continue;
                    sb.append("#    - '").append(path).append("'\n");
                }
                sb.append("    extract:\n");
                sb.append("#    - 'DeviceClass                         :      1 :' \n");
                sb.append("#    - 'DeviceBrand                         :      1 :' \n");
                sb.append("#    - 'DeviceName                          :      1 :' \n");
                sb.append("#    - 'OperatingSystemClass                :      1 :' \n");
                sb.append("#    - 'OperatingSystemName                 :      1 :' \n");
                sb.append("#    - 'OperatingSystemVersion              :      1 :' \n");
                sb.append("#    - 'LayoutEngineClass                   :      1 :' \n");
                sb.append("#    - 'LayoutEngineName                    :      1 :' \n");
                sb.append("#    - 'LayoutEngineVersion                 :      1 :' \n");
                sb.append("#    - 'AgentClass                          :      1 :' \n");
                sb.append("#    - 'AgentName                           :      1 :' \n");
                sb.append("#    - 'AgentVersion                        :      1 :' \n");
                sb.append('\n');
                sb.append('\n');
                LOG.info("%s", (Object)sb);
            }
            sb.setLength(0);
            sb.append("+--------+-");
            for (i2 = 0; i2 < maxNameLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+-");
            for (i2 = 0; i2 < maxActualLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+---------+------------+-");
            for (i2 = 0; i2 < maxExpectedLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+");
            String separator = sb.toString();
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, separator, new Object[0]);
            sb.setLength(0);
            sb.append("| Result | Field ");
            for (i = 6; i < maxNameLength; ++i) {
                sb.append(' ');
            }
            sb.append(" | Actual ");
            for (i = 7; i < maxActualLength; ++i) {
                sb.append(' ');
            }
            sb.append(" | Default | Confidence | Expected ");
            for (i = 9; i < maxExpectedLength; ++i) {
                sb.append(' ');
            }
            sb.append(" |");
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, sb.toString(), new Object[0]);
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, separator, new Object[0]);
            HashMap<String, String> failComments = new HashMap<String, String>();
            ArrayList<String> failedFieldNames = new ArrayList<String>();
            for (TestResult result : results) {
                int i6;
                sb.setLength(0);
                if (result.pass) {
                    sb.append("|        | ");
                } else if (result.warn) {
                    sb.append("| ~warn~ | ");
                    failComments.put(result.field, "~~ Unexpected result ~~");
                } else {
                    sb.append("| -FAIL- | ");
                    failComments.put(result.field, "FAILED; Should be '" + result.expected + "'");
                    failedFieldNames.add(result.field);
                }
                sb.append(result.field);
                for (i6 = result.field.length(); i6 < maxNameLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" | ");
                sb.append(result.actual);
                for (i6 = result.actual.length(); i6 < maxActualLength; ++i6) {
                    sb.append(' ');
                }
                if (result.isDefault) {
                    sb.append(" | Default | ");
                } else {
                    sb.append(" |         | ");
                }
                sb.append(String.format("%10d", result.confidence));
                sb.append(" | ");
                if (result.pass) {
                    for (i6 = 0; i6 < maxExpectedLength; ++i6) {
                        sb.append(' ');
                    }
                    sb.append(" |");
                    AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, sb.toString(), new Object[0]);
                    continue;
                }
                sb.append(result.expected);
                for (i6 = result.expected.length(); i6 < maxExpectedLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" |");
                if (result.warn) {
                    AbstractUserAgentAnalyzerTester.logWarn(errorMessageReceiver, sb.toString(), new Object[0]);
                    continue;
                }
                AbstractUserAgentAnalyzerTester.logError(errorMessageReceiver, sb.toString(), new Object[0]);
            }
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, separator, new Object[0]);
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, "", new Object[0]);
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, agent.toMatchTrace(failedFieldNames), new Object[0]);
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, "\n\nconfig:\n{}", parseResult.toYamlTestCase(!init, failComments));
            AbstractUserAgentAnalyzerTester.logInfo(errorMessageReceiver, "Location of failed test.({}:{})", filename, linenumber);
            if (!pass && !showAll) {
                return false;
            }
            if (!init) continue;
            return allPass;
        }
        if (showPassedTests) {
            LOG.info("+===========================================================================================");
        } else {
            LOG.info("All %d tests passed", (Object)testcount);
        }
        long fullStop = System.nanoTime();
        LOG.info("This took %8.3f ms for %5d tests : averaging to %6.3f msec/test (This includes test validation and logging!!)", (Object)((double)(fullStop - fullStart) / 1000000.0), (Object)testcount, (Object)((double)(fullStop - fullStart) / (double)((long)testcount * 1000000L)));
        if (testcount == 0) {
            LOG.error("NO tests were run at all!!!");
            allPass = false;
        }
        return allPass;
    }

    public List<MatchesList.Match> getMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (Matcher matcher : this.getAllMatchers()) {
            allMatches.addAll(matcher.getMatches());
        }
        return allMatches;
    }

    public synchronized List<MatchesList.Match> getUsedMatches(UserAgent.MutableUserAgent userAgent) {
        for (Matcher matcher : this.getAllMatchers()) {
            matcher.reset();
            matcher.setVerboseTemporarily(false);
        }
        this.flattener.parse(userAgent);
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (Matcher matcher : this.getAllMatchers()) {
            allMatches.addAll(matcher.getUsedMatches());
        }
        return allMatches;
    }

    public void analyzeMatcherImpactAllTests() {
        if (this.getTestCases() == null) {
            return;
        }
        this.initializeMatchers();
        DebugUserAgent agent = new DebugUserAgent(this.getWantedFieldNames());
        this.setVerbose(false);
        agent.setDebug(false);
        TreeMap<String, MatcherImpact> impactOverview = new TreeMap<String, MatcherImpact>();
        ArrayList impactList = new ArrayList();
        this.getAllMatchers().stream().sorted(Comparator.comparing(Matcher::getSourceFileName).thenComparingLong(Matcher::getSourceFileLineNumber)).forEach(matcher -> {
            MatcherImpact matcherImpact = new MatcherImpact();
            matcherImpact.neededInputs = matcher.getActionsThatRequireInput();
            matcherImpact.name = matcher.getMatcherSourceLocation();
            impactOverview.put(matcher.getMatcherSourceLocation(), matcherImpact);
            impactList.add(matcherImpact);
        });
        for (TestCase test : this.getTestCases()) {
            String userAgentString = test.getUserAgent();
            agent.setUserAgentString(userAgentString);
            this.parse(agent);
            impactOverview.forEach((n, i) -> ++i.tests);
            this.getTouchedMatchers().forEach(m -> {
                MatcherImpact impact = (MatcherImpact)impactOverview.get(m.getMatcherSourceLocation());
                ++impact.touched;
                if (m.getActionsThatRequireInput() == m.getActionsThatRequireInputAndReceivedInput()) {
                    ++impact.enoughInputs;
                    if (!m.getUsedMatches().isEmpty()) {
                        ++impact.used;
                    }
                }
            });
        }
        impactList.forEach(i -> LOG.info("%s", i));
    }

    @Override
    public String toString() {
        return "UserAgentAnalyzerTester {\n" + super.toString() + "\n} ";
    }

    public static abstract class AbstractUserAgentAnalyzerTesterBuilder<UAA extends AbstractUserAgentAnalyzerTester, B extends AbstractUserAgentAnalyzer.AbstractUserAgentAnalyzerBuilder<UAA, B>>
    extends AbstractUserAgentAnalyzer.AbstractUserAgentAnalyzerBuilder<UAA, B> {
        AbstractUserAgentAnalyzerTesterBuilder(UAA newUaa) {
            super(newUaa);
        }

        @Override
        public UAA build() {
            AbstractUserAgentAnalyzerTester analyzer = (AbstractUserAgentAnalyzerTester)super.build();
            this.verifyCalculatorDependencyOrdering();
            return (UAA)analyzer;
        }
    }

    private static class MatcherImpact {
        String name;
        long neededInputs;
        long tests;
        long touched;
        long enoughInputs;
        long used;

        private MatcherImpact() {
        }

        public String toString() {
            return String.format("%-45s --> touched= %5d (%3.0f%%), neededInputs = %2d, enoughInputs = %5d (%3.0f%%), used = %5d (%3.0f%%) %s%s%s", "Rule.(" + this.name + ")", this.touched, 100.0 * ((double)this.touched / (double)this.tests), this.neededInputs, this.enoughInputs, this.touched == 0L ? 0.0 : 100.0 * ((double)this.enoughInputs / (double)this.touched), this.used, this.enoughInputs == 0L ? 0.0 : 100.0 * ((double)this.used / (double)this.enoughInputs), this.touched == 0L ? "~~~" : "", this.enoughInputs > 0L && this.used == 0L ? "<-- NEVER USED " : "", this.enoughInputs > 100L && this.used == 0L ? ">> SEVERE CASE <<" : "");
        }
    }

    static class TestResult {
        String field;
        String expected;
        String actual;
        boolean isDefault;
        boolean pass;
        boolean warn;
        long confidence;

        TestResult() {
        }
    }

    public static class KryoSerializer
    extends AbstractUserAgentAnalyzerDirect.KryoSerializer {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }
    }
}

