/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.Serializable;
import java.util.Objects;

public interface AgentField
extends Serializable {
    public String getValue();

    public long getConfidence();

    public boolean isDefaultValue();

    public String getDefaultValue();

    default public boolean afEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentField)) {
            return false;
        }
        AgentField agentField = (AgentField)o;
        return Objects.equals(this.getConfidence(), agentField.getConfidence()) && Objects.equals(this.getValue(), agentField.getValue()) && Objects.equals(this.getDefaultValue(), agentField.getDefaultValue()) && Objects.equals(this.isDefaultValue(), agentField.isDefaultValue());
    }

    default public int afHashCode() {
        return Objects.hash(this.getConfidence(), this.getValue(), this.getDefaultValue(), this.isDefaultValue());
    }

    default public String afToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ value:'").append(this.getValue()).append("', confidence:'").append(this.getConfidence()).append("', ");
        String defaultValue = this.getDefaultValue();
        if (defaultValue == null) {
            sb.append("default:null, ");
        } else {
            sb.append("default:'").append(this.getDefaultValue()).append("', ");
        }
        sb.append("isDefault:").append(this.isDefaultValue()).append(" }");
        return sb.toString();
    }

    public static class ImmutableAgentField
    implements AgentField {
        private final String value;
        private final long confidence;
        private final boolean isDefaultValue;
        private final String defaultValue;

        public ImmutableAgentField(String value, long confidence, boolean isDefaultValue, String defaultValue) {
            this.value = value;
            this.confidence = confidence;
            this.isDefaultValue = isDefaultValue;
            this.defaultValue = defaultValue;
        }

        public ImmutableAgentField(MutableAgentField agentField) {
            this.value = agentField.getValue();
            this.confidence = agentField.getConfidence();
            this.isDefaultValue = agentField.isDefaultValue();
            this.defaultValue = agentField.getDefaultValue();
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public long getConfidence() {
            return this.confidence;
        }

        @Override
        public boolean isDefaultValue() {
            return this.isDefaultValue;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            return this.afEquals(o);
        }

        public int hashCode() {
            return this.afHashCode();
        }

        public String toString() {
            return this.afToString();
        }
    }

    public static class MutableAgentField
    implements AgentField {
        final String defaultValue;
        String value;
        long confidence;

        private MutableAgentField() {
            this.defaultValue = null;
        }

        MutableAgentField(String defaultValue) {
            this.defaultValue = defaultValue;
            this.reset();
        }

        public void reset() {
            this.value = null;
            this.confidence = -1L;
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                return this.defaultValue;
            }
            return this.value;
        }

        @Override
        public boolean isDefaultValue() {
            return this.confidence < 0L || this.value == null;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public long getConfidence() {
            return this.confidence;
        }

        public boolean setValue(MutableAgentField field) {
            return this.setValue(field.value, field.confidence);
        }

        public boolean setValue(String newValue, long newConfidence) {
            if (newConfidence > this.confidence) {
                this.setValueForced(newValue, newConfidence);
                return true;
            }
            return false;
        }

        public void setValueForced(String newValue, long newConfidence) {
            this.confidence = newConfidence;
            this.value = "<<<null>>>".equals(newValue) ? null : newValue;
        }

        public boolean equals(Object o) {
            return this.afEquals(o);
        }

        public int hashCode() {
            return this.afHashCode();
        }

        public String toString() {
            return this.afToString();
        }
    }
}

